/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack.action;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackBuildInstructionComponent;
import uk.co.cablepost.ftech_equipment.backpack.RoboticDrillItem;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmActionContext;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmTask;
import uk.co.cablepost.ftech_equipment.backpack.action.SimpleExtendRetractAction;

public class PlacingAction
extends SimpleExtendRetractAction {
    public static final class_2960 ID = new class_2960("f_tech_equipment", "placing");

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    @Nullable
    public ArmTask findTask(ArmActionContext ctx) {
        class_2338 playerPos = ctx.getPlayerPos();
        for (int x = playerPos.method_10263() - 10; x <= playerPos.method_10263() + 10; ++x) {
            for (int y = playerPos.method_10264() - 10; y <= playerPos.method_10264() + 10; ++y) {
                for (int z = playerPos.method_10260() - 10; z <= playerPos.method_10260() + 10; ++z) {
                    class_1799 blockToPlace;
                    class_1799 retrieved;
                    class_2338 pos = new class_2338(x, y, z);
                    Optional<class_2680> buildInstruction = this.getBuildTargetBlockState(ctx, pos);
                    if (buildInstruction.isEmpty() || buildInstruction.get().method_27852(class_2246.field_10369) || !ctx.hasLineOfSight(pos) || ctx.isPositionTargetedByOtherArm(pos) || (retrieved = ctx.retrieveItem(blockToPlace = buildInstruction.get().method_26204().method_8389().method_7854())) == null || retrieved.method_7960()) continue;
                    return new ArmTask(pos.method_46558(), retrieved);
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    protected BackpackArmComponent onExtending(ArmActionContext ctx) {
        class_2338 playerPos = ctx.getPlayerPos();
        if (ctx.armData().extendedPos().method_1022(playerPos.method_46558()) > 20.0) {
            class_1799 holding = ctx.armData().holdingStack();
            if (!holding.method_7960() && !(holding.method_7909() instanceof RoboticDrillItem)) {
                ctx.storeItem(holding);
            }
            return ctx.armData().startRetracting().withHolding(class_1799.field_8037);
        }
        return null;
    }

    @Override
    @Nullable
    protected BackpackArmComponent onArrived(ArmActionContext ctx) {
        boolean instructionInvalid;
        BackpackArmComponent arm = ctx.armData();
        class_2338 blockPos = class_2338.method_49638((class_2374)arm.extendedPos());
        Optional<class_2680> buildInstruction = this.getBuildTargetBlockState(ctx, blockPos);
        boolean bl = instructionInvalid = buildInstruction.isEmpty() || buildInstruction.get().method_27852(class_2246.field_10369) || buildInstruction.get().method_26204().method_8389() != arm.holdingStack().method_7909();
        if (instructionInvalid) {
            class_1799 holding = arm.holdingStack();
            if (!holding.method_7960() && !(holding.method_7909() instanceof RoboticDrillItem)) {
                ctx.storeItem(holding);
            }
            return arm.startRetracting().withHolding(class_1799.field_8037);
        }
        ctx.level().method_8501(blockPos, buildInstruction.get());
        ctx.level().method_8396(null, blockPos, buildInstruction.get().method_26231().method_10598(), class_3419.field_15245, 1.0f, 1.0f);
        ctx.removeBuildInstruction(blockPos, buildInstruction.get());
        return arm.startRetracting().withHolding(class_1799.field_8037);
    }

    @Override
    @Nullable
    protected BackpackArmComponent onRetracted(ArmActionContext ctx) {
        return ctx.armData().idle();
    }

    private Optional<class_2680> getBuildTargetBlockState(ArmActionContext ctx, class_2338 pos) {
        List<BackpackBuildInstructionComponent> instructions = ctx.buildInstructions();
        class_2680 currentBlockState = ctx.level().method_8320(pos);
        for (BackpackBuildInstructionComponent instruction : instructions) {
            if (!FTechEquipment.blockPosesEqual(instruction.blockPos(), pos)) continue;
            boolean breakInstruction = instruction.targetBlockState().method_27852(class_2246.field_10369);
            if (breakInstruction) {
                return Optional.of(instruction.targetBlockState());
            }
            if (!currentBlockState.method_26215() && !currentBlockState.method_45474()) {
                ctx.removeBuildInstruction(pos, instruction.targetBlockState());
                return Optional.empty();
            }
            return Optional.of(instruction.targetBlockState());
        }
        return Optional.empty();
    }
}

