/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack.action;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmComponent;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmActionContext;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmTask;
import uk.co.cablepost.ftech_equipment.backpack.action.SimpleExtendRetractAction;

public class PickupAction
extends SimpleExtendRetractAction {
    public static final class_2960 ID = new class_2960("f_tech_equipment", "pickup");
    public static final String KEY_TARGET_ENTITY_ID = "pickupTargetEntityId";

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    @Nullable
    public ArmTask findTask(ArmActionContext ctx) {
        if (!ctx.hasUpgrade((class_1792)FTechEquipment.ITEM_PICKUP_UPGRADE_ITEM.get())) {
            return null;
        }
        if (!ctx.isItemPickupEnabled()) {
            return null;
        }
        int availableSpace = ctx.getMaxCapacity() - ctx.getCurrentItemCount();
        if (availableSpace <= 0) {
            return null;
        }
        List nearbyItems = ctx.level().method_8390(class_1542.class, ctx.entity().method_5829().method_1014(8.0), item -> item.method_5805() && !item.method_6977());
        for (class_1542 itemEntity : nearbyItems) {
            class_243 itemPos;
            if (itemEntity.method_6983().method_7947() > availableSpace || ctx.isEntityTargetedByOtherArm(itemEntity.method_5628()) || !ctx.hasLineOfSight(itemPos = itemEntity.method_19538().method_1031(0.0, 0.25, 0.0))) continue;
            class_2487 state = new class_2487();
            state.method_10569(KEY_TARGET_ENTITY_ID, itemEntity.method_5628());
            return new ArmTask(itemPos, class_1799.field_8037, state);
        }
        return null;
    }

    @Override
    @Nullable
    protected BackpackArmComponent onExtending(ArmActionContext ctx) {
        BackpackArmComponent arm = ctx.armData();
        int targetEntityId = arm.actionState().method_10550(KEY_TARGET_ENTITY_ID);
        class_1542 itemEntity = this.findTargetItem(ctx, targetEntityId, arm.extendedPos());
        if (itemEntity == null) {
            return arm.startRetracting().withHolding(class_1799.field_8037).withActionState(new class_2487());
        }
        class_243 itemPos = itemEntity.method_19538().method_1031(0.0, 0.25, 0.0);
        if (itemPos.method_1022(ctx.getPlayerPos().method_46558()) > 10.0) {
            return arm.startRetracting().withHolding(class_1799.field_8037).withActionState(new class_2487());
        }
        class_2487 state = arm.actionState().method_10553();
        state.method_10569(KEY_TARGET_ENTITY_ID, itemEntity.method_5628());
        return arm.withExtendedPos(itemPos).withActionState(state);
    }

    @Override
    @Nullable
    protected BackpackArmComponent onArrived(ArmActionContext ctx) {
        BackpackArmComponent arm = ctx.armData();
        int targetEntityId = arm.actionState().method_10550(KEY_TARGET_ENTITY_ID);
        class_1542 itemEntity = this.findTargetItem(ctx, targetEntityId, arm.extendedPos());
        if (itemEntity == null) {
            return arm.startRetracting().withHolding(class_1799.field_8037).withActionState(new class_2487());
        }
        class_1799 pickedUp = itemEntity.method_6983().method_7972();
        itemEntity.method_31472();
        class_243 itemPos = itemEntity.method_19538().method_1031(0.0, 0.25, 0.0);
        return arm.withExtendedPos(itemPos).startRetracting().withHolding(pickedUp).withActionState(new class_2487());
    }

    @Override
    @Nullable
    protected BackpackArmComponent onRetracting(ArmActionContext ctx) {
        return null;
    }

    @Override
    @Nullable
    protected BackpackArmComponent onRetracted(ArmActionContext ctx) {
        int remainder;
        BackpackArmComponent arm = ctx.armData();
        if (!arm.holdingStack().method_7960() && (remainder = ctx.storeItem(arm.holdingStack())) > 0) {
            class_1799 toDrop = arm.holdingStack().method_7972();
            toDrop.method_7939(remainder);
            class_1542 itemEntity = new class_1542(ctx.level(), ctx.entity().method_23317(), ctx.entity().method_23318() + 1.0, ctx.entity().method_23321(), toDrop);
            ctx.level().method_8649((class_1297)itemEntity);
        }
        return arm.idle();
    }

    @Nullable
    private class_1542 findTargetItem(ArmActionContext ctx, int targetEntityId, class_243 targetPos) {
        List nearbyItems;
        class_1297 targetEntity = ctx.level().method_8469(targetEntityId);
        if (targetEntity instanceof class_1542) {
            class_1542 ie = (class_1542)targetEntity;
            if (targetEntity.method_5805()) {
                return ie;
            }
        }
        if ((nearbyItems = ctx.level().method_8390(class_1542.class, class_238.method_30048((class_243)targetPos, (double)2.0, (double)2.0, (double)2.0), item -> item.method_5805())).isEmpty()) {
            return null;
        }
        return nearbyItems.stream().min((a, b) -> Double.compare(a.method_19538().method_1025(targetPos), b.method_19538().method_1025(targetPos))).orElse(null);
    }
}

