/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack.action;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackBuildInstructionComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.RoboticDrillItem;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmActionContext;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmTask;
import uk.co.cablepost.ftech_equipment.backpack.action.SimpleExtendRetractAction;

public class MiningAction
extends SimpleExtendRetractAction {
    public static final class_2960 ID = new class_2960("f_tech_equipment", "mining");
    public static final String KEY_MINING_PROGRESS = "miningProgress";
    public static final String KEY_MINING_TOTAL_TICKS = "miningTotalTicks";

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    @Nullable
    public ArmTask findTask(ArmActionContext ctx) {
        class_1799 drill = ctx.getDrill();
        if (drill == null || drill.method_7960() || !(drill.method_7909() instanceof RoboticDrillItem)) {
            return null;
        }
        class_2338 playerPos = ctx.getPlayerPos();
        for (int x = playerPos.method_10263() - 10; x <= playerPos.method_10263() + 10; ++x) {
            for (int y = playerPos.method_10264() - 10; y <= playerPos.method_10264() + 10; ++y) {
                for (int z = playerPos.method_10260() - 10; z <= playerPos.method_10260() + 10; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    Optional<class_2680> buildInstruction = this.getBuildTargetBlockState(ctx, pos);
                    if (buildInstruction.isEmpty() || !buildInstruction.get().method_27852(class_2246.field_10369) || !ctx.hasLineOfSight(pos) || ctx.isPositionTargetedByOtherArm(pos)) continue;
                    return new ArmTask(pos.method_46558(), drill.method_7972(), new class_2487());
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    protected BackpackArmComponent onExtending(ArmActionContext ctx) {
        class_2338 playerPos = ctx.getPlayerPos();
        if (ctx.armData().extendedPos().method_1022(playerPos.method_46558()) > 20.0) {
            return this.cancelMining(ctx);
        }
        return null;
    }

    @Override
    @Nullable
    protected BackpackArmComponent onArrived(ArmActionContext ctx) {
        class_1792 class_17922;
        BackpackArmComponent arm = ctx.armData();
        class_2338 blockPos = class_2338.method_49638((class_2374)arm.extendedPos());
        class_1937 level = ctx.level();
        Optional<class_2680> buildInstruction = this.getBuildTargetBlockState(ctx, blockPos);
        if (buildInstruction.isEmpty() || !buildInstruction.get().method_27852(class_2246.field_10369)) {
            return this.cancelMining(ctx);
        }
        class_1799 drill = ctx.getDrill();
        if (drill == null || drill.method_7960() || !((class_17922 = drill.method_7909()) instanceof RoboticDrillItem)) {
            ctx.removeBuildInstruction(blockPos, buildInstruction.get());
            return arm.startRetracting().withActionState(new class_2487());
        }
        RoboticDrillItem drillItem = (RoboticDrillItem)class_17922;
        class_2680 currentBlock = level.method_8320(blockPos);
        if (currentBlock.method_27852(class_2246.field_10382) || currentBlock.method_27852(class_2246.field_10164)) {
            ctx.removeBuildInstruction(blockPos, buildInstruction.get());
            return arm.startRetracting().withActionState(new class_2487());
        }
        if (currentBlock.method_26215()) {
            ctx.removeBuildInstruction(blockPos, buildInstruction.get());
            return arm.startRetracting().withActionState(new class_2487());
        }
        class_2487 state = arm.actionState().method_10553();
        int miningProgress = state.method_10550(KEY_MINING_PROGRESS);
        int miningTotalTicks = state.method_10550(KEY_MINING_TOTAL_TICKS);
        if (miningTotalTicks == 0) {
            float hardness = currentBlock.method_26214((class_1922)level, blockPos);
            int ticksToMine = drillItem.getBreakingTicks(currentBlock, hardness, drill);
            if (ticksToMine < 0) {
                ctx.removeBuildInstruction(blockPos, buildInstruction.get());
                return arm.startRetracting().withActionState(new class_2487());
            }
            if (ticksToMine <= 1) {
                this.completeMining(ctx, blockPos, currentBlock, drill, drillItem, buildInstruction.get());
                return arm.startRetracting().withHolding(drill.method_7972()).withActionState(new class_2487());
            }
            state.method_10569(KEY_MINING_PROGRESS, 1);
            state.method_10569(KEY_MINING_TOTAL_TICKS, ticksToMine);
            return arm.withActionState(state);
        }
        int newMiningProgress = miningProgress + 1;
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            int stage = (int)((float)newMiningProgress / (float)miningTotalTicks * 10.0f);
            stage = Math.min(stage, 9);
            serverLevel.method_8517(ctx.arm().ordinal() + 1000, blockPos, stage);
            if (newMiningProgress % 4 == 0) {
                class_2498 soundType = currentBlock.method_26231();
                level.method_8396(null, blockPos, soundType.method_10596(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 8.0f, soundType.method_10599() * 0.5f);
            }
        }
        if (newMiningProgress >= miningTotalTicks) {
            this.completeMining(ctx, blockPos, currentBlock, drill, drillItem, buildInstruction.get());
            return arm.startRetracting().withHolding(drill.method_7972()).withActionState(new class_2487());
        }
        state.method_10569(KEY_MINING_PROGRESS, newMiningProgress);
        return arm.withActionState(state);
    }

    @Override
    @Nullable
    protected BackpackArmComponent onRetracted(ArmActionContext ctx) {
        return ctx.armData().idle();
    }

    private BackpackArmComponent cancelMining(ArmActionContext ctx) {
        class_1799 holding;
        BackpackArmComponent arm = ctx.armData();
        class_2338 blockPos = class_2338.method_49638((class_2374)arm.extendedPos());
        class_1937 class_19372 = ctx.level();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (arm.actionState().method_10550(KEY_MINING_TOTAL_TICKS) > 0) {
                serverLevel.method_8517(ctx.arm().ordinal() + 1000, blockPos, -1);
            }
        }
        if (!(holding = arm.holdingStack()).method_7960() && !(holding.method_7909() instanceof RoboticDrillItem)) {
            ctx.storeItem(holding);
        }
        class_1799 retractingStack = holding.method_7909() instanceof RoboticDrillItem ? holding : class_1799.field_8037;
        return arm.startRetracting().withHolding(retractingStack).withActionState(new class_2487());
    }

    private void completeMining(ArmActionContext ctx, class_2338 blockPos, class_2680 minedBlock, class_1799 drill, RoboticDrillItem drillItem, class_2680 buildInstruction) {
        class_1937 level = ctx.level();
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_8517(ctx.arm().ordinal() + 1000, blockPos, -1);
        }
        List drops = class_2248.method_9609((class_2680)minedBlock, (class_3218)((class_3218)level), (class_2338)blockPos, (class_2586)level.method_8321(blockPos), null, (class_1799)drill);
        for (class_1799 drop : drops) {
            int remainder = ctx.storeItem(drop);
            if (remainder <= 0) continue;
            class_1799 toDrop = drop.method_7972();
            toDrop.method_7939(remainder);
            class_1542 itemEntity = new class_1542(level, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, toDrop);
            level.method_8649((class_1297)itemEntity);
        }
        level.method_20290(2001, blockPos, class_2248.method_9507((class_2680)minedBlock));
        if (!minedBlock.method_26227().method_15769()) {
            level.method_8501(blockPos, minedBlock.method_26227().method_15759());
        } else {
            level.method_8501(blockPos, class_2246.field_10124.method_9564());
        }
        boolean drillStillUsable = drillItem.damageAfterMining(drill);
        if (!drillStillUsable) {
            BackpackItem.setDrillForArm(ctx.backpack(), ctx.arm(), class_1799.field_8037);
        } else {
            BackpackItem.setDrillForArm(ctx.backpack(), ctx.arm(), drill);
        }
        ctx.removeBuildInstruction(blockPos, buildInstruction);
    }

    private Optional<class_2680> getBuildTargetBlockState(ArmActionContext ctx, class_2338 pos) {
        List<BackpackBuildInstructionComponent> instructions = ctx.buildInstructions();
        class_2680 currentBlockState = ctx.level().method_8320(pos);
        for (BackpackBuildInstructionComponent instruction : instructions) {
            if (!FTechEquipment.blockPosesEqual(instruction.blockPos(), pos)) continue;
            boolean breakInstruction = instruction.targetBlockState().method_27852(class_2246.field_10369);
            if (breakInstruction) {
                if (currentBlockState.method_26215()) {
                    ctx.removeBuildInstruction(pos, instruction.targetBlockState());
                    return Optional.empty();
                }
            } else if (!currentBlockState.method_26215() && !currentBlockState.method_45474()) {
                ctx.removeBuildInstruction(pos, instruction.targetBlockState());
                return Optional.empty();
            }
            return Optional.of(instruction.targetBlockState());
        }
        return Optional.empty();
    }
}

