/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack.action;

import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_1510;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1593;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_4760;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArm;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackBuildInstructionComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.BackpackWeaponSlotsComponent;
import uk.co.cablepost.ftech_equipment.backpack.RoboticDrillItem;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmAction;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmActionContext;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmMotion;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmTask;
import uk.co.cablepost.ftech_equipment.backpack.action.AttackAction;
import uk.co.cablepost.ftech_equipment.backpack.action.MiningAction;
import uk.co.cablepost.ftech_equipment.backpack.action.PickupAction;
import uk.co.cablepost.ftech_equipment.backpack.action.PlacingAction;
import uk.co.cablepost.ftech_equipment.backpack.inventory.BackpackItemComponent;
import uk.co.cablepost.ftech_equipment.backpack.locomotion.GrabSurfaceDetector;
import uk.co.cablepost.ftech_equipment.backpack.locomotion.GrabTarget;
import uk.co.cablepost.ftech_equipment.backpack.locomotion.GrabType;
import uk.co.cablepost.ftech_equipment.backpack.locomotion.LocomotionController;

public class LocomotionAction
implements ArmAction {
    public static final class_2960 ID = new class_2960("f_tech_equipment", "locomotion");
    public static final String KEY_IS_GRABBING = "isGrabbing";
    public static final String KEY_GRAB_BLOCK_X = "grabBlockX";
    public static final String KEY_GRAB_BLOCK_Y = "grabBlockY";
    public static final String KEY_GRAB_BLOCK_Z = "grabBlockZ";
    public static final String KEY_FINGER_ANGLE = "fingerAngle";
    public static final String KEY_HOLD_TICKS = "holdTicks";

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public ArmMotion getMotion() {
        return ArmMotion.EXTEND_RETRACT;
    }

    @Override
    public int getPriority() {
        return 4;
    }

    @Override
    @Nullable
    public ArmTask findTask(ArmActionContext ctx) {
        if (!ctx.hasUpgrade((class_1792)FTechEquipment.LOCOMOTION_UPGRADE_ITEM.get())) {
            return null;
        }
        if (!BackpackItem.isLocomotionEnabled(ctx.backpack())) {
            return null;
        }
        if (!this.needsLocomotion(ctx)) {
            return null;
        }
        if (this.shouldYieldArm(ctx)) {
            return null;
        }
        GrabTarget target = GrabSurfaceDetector.findGrabSurface(ctx.entity(), ctx.arm(), LocomotionController.GRAB_RANGE, ctx.backpack());
        if (target == null) {
            return null;
        }
        if (!ctx.hasLineOfSight(target.position())) {
            return null;
        }
        if (ctx.isPositionTargetedByOtherArm(target.blockPos())) {
            return null;
        }
        if (this.isTargetTooCloseToOtherArms(ctx, target.position())) {
            return null;
        }
        class_2487 state = new class_2487();
        state.method_10556(KEY_IS_GRABBING, false);
        state.method_10569(KEY_GRAB_BLOCK_X, target.blockPos().method_10263());
        state.method_10569(KEY_GRAB_BLOCK_Y, target.blockPos().method_10264());
        state.method_10569(KEY_GRAB_BLOCK_Z, target.blockPos().method_10260());
        state.method_10548(KEY_FINGER_ANGLE, target.type() == GrabType.CORNER ? LocomotionController.CORNER_GRAB_FINGER_ANGLE : LocomotionController.SIDE_GRAB_FINGER_ANGLE);
        state.method_10569(KEY_HOLD_TICKS, 0);
        return new ArmTask(target.position(), class_1799.field_8037, state);
    }

    @Override
    @Nullable
    public BackpackArmComponent tick(ArmActionContext ctx) {
        BackpackArmComponent arm = ctx.armData();
        class_2487 state = arm.actionState().method_10553();
        if (!BackpackItem.isLocomotionEnabled(ctx.backpack())) {
            return this.startRelease(arm);
        }
        class_2338 grabBlock = new class_2338(state.method_10550(KEY_GRAB_BLOCK_X), state.method_10550(KEY_GRAB_BLOCK_Y), state.method_10550(KEY_GRAB_BLOCK_Z));
        class_2680 blockState = ctx.level().method_8320(grabBlock);
        if (blockState.method_26215() || !GrabSurfaceDetector.isSolidGrabbable(blockState, ctx.level(), grabBlock)) {
            return this.startRelease(arm);
        }
        if (arm.direction() == 1) {
            if (arm.progress() >= 0.99f) {
                state.method_10556(KEY_IS_GRABBING, true);
                state.method_10569(KEY_HOLD_TICKS, 0);
                if (!ctx.level().field_9236) {
                    class_243 grabPos = arm.extendedPos();
                    ctx.level().method_43128(null, grabPos.field_1352, grabPos.field_1351, grabPos.field_1350, blockState.method_26231().method_10594(), class_3419.field_15248, 0.1f, 1.0f);
                }
                return arm.withDirection(2).withProgress(1.0f).withActionState(state);
            }
            return null;
        }
        boolean isGrabbing = state.method_10577(KEY_IS_GRABBING);
        if (isGrabbing && arm.direction() == 2 && arm.progress() >= 0.99f) {
            double newDistance;
            GrabTarget newTarget;
            double distanceThreshold;
            boolean outOfRange;
            int holdTicks = state.method_10550(KEY_HOLD_TICKS) + 1;
            state.method_10569(KEY_HOLD_TICKS, holdTicks);
            int otherGrabbingArms = this.countOtherGrabbingArms(ctx);
            int tier = this.getArmTier(ctx.arm());
            if (otherGrabbingArms >= 4 && tier <= 1 && this.otherActionsHavePendingTasks(ctx)) {
                return this.startRelease(arm);
            }
            double distance = ctx.entity().method_33571().method_1022(arm.extendedPos());
            boolean bl = outOfRange = distance > LocomotionController.GRAB_RANGE * 1.3;
            if (outOfRange) {
                GrabTarget newTarget2 = GrabSurfaceDetector.findGrabSurface(ctx.entity(), ctx.arm(), LocomotionController.GRAB_RANGE, ctx.backpack());
                if (newTarget2 != null && ctx.hasLineOfSight(newTarget2.position()) && !ctx.isPositionTargetedByOtherArm(newTarget2.blockPos()) && !this.isTargetTooCloseToOtherArms(ctx, newTarget2.position())) {
                    double transitionDistance = arm.extendedPos().method_1022(newTarget2.position());
                    float newProgress = (float)Math.max(0.1, 0.5 - transitionDistance / LocomotionController.GRAB_RANGE * 0.3);
                    class_2487 newState = new class_2487();
                    newState.method_10556(KEY_IS_GRABBING, false);
                    newState.method_10569(KEY_GRAB_BLOCK_X, newTarget2.blockPos().method_10263());
                    newState.method_10569(KEY_GRAB_BLOCK_Y, newTarget2.blockPos().method_10264());
                    newState.method_10569(KEY_GRAB_BLOCK_Z, newTarget2.blockPos().method_10260());
                    newState.method_10548(KEY_FINGER_ANGLE, newTarget2.type() == GrabType.CORNER ? LocomotionController.CORNER_GRAB_FINGER_ANGLE : LocomotionController.SIDE_GRAB_FINGER_ANGLE);
                    newState.method_10569(KEY_HOLD_TICKS, 0);
                    return arm.withExtendedPos(newTarget2.position()).withProgress(newProgress).withDirection(1).withActionState(newState);
                }
                return this.startRelease(arm);
            }
            int checkInterval = switch (tier) {
                case 0 -> 1;
                case 1 -> 1;
                case 2 -> 2;
                default -> 2;
            };
            switch (tier) {
                case 0: {
                    double d = 0.05;
                    break;
                }
                case 1: {
                    double d = 0.25;
                    break;
                }
                case 2: {
                    double d = 0.5;
                    break;
                }
                default: {
                    double d = distanceThreshold = 0.75;
                }
            }
            if (holdTicks % checkInterval == 0 && holdTicks > 0 && otherGrabbingArms >= LocomotionController.MIN_ARMS_FOR_LOCOMOTION - 1 && distance > LocomotionController.GRAB_RANGE * distanceThreshold && (newTarget = GrabSurfaceDetector.findGrabSurface(ctx.entity(), ctx.arm(), LocomotionController.GRAB_RANGE, ctx.backpack())) != null && ctx.hasLineOfSight(newTarget.position()) && !ctx.isPositionTargetedByOtherArm(newTarget.blockPos()) && !this.isTargetTooCloseToOtherArms(ctx, newTarget.position()) && (newDistance = ctx.entity().method_33571().method_1022(newTarget.position())) < distance * 0.85) {
                double transitionDistance = arm.extendedPos().method_1022(newTarget.position());
                float newProgress = (float)Math.max(0.1, 0.5 - transitionDistance / LocomotionController.GRAB_RANGE * 0.3);
                class_2487 newState = new class_2487();
                newState.method_10556(KEY_IS_GRABBING, false);
                newState.method_10569(KEY_GRAB_BLOCK_X, newTarget.blockPos().method_10263());
                newState.method_10569(KEY_GRAB_BLOCK_Y, newTarget.blockPos().method_10264());
                newState.method_10569(KEY_GRAB_BLOCK_Z, newTarget.blockPos().method_10260());
                newState.method_10548(KEY_FINGER_ANGLE, newTarget.type() == GrabType.CORNER ? LocomotionController.CORNER_GRAB_FINGER_ANGLE : LocomotionController.SIDE_GRAB_FINGER_ANGLE);
                newState.method_10569(KEY_HOLD_TICKS, 0);
                return arm.withExtendedPos(newTarget.position()).withProgress(newProgress).withDirection(1).withActionState(newState);
            }
            return arm.withActionState(state);
        }
        if (arm.direction() == 0 && arm.progress() <= 0.01f) {
            return arm.idle();
        }
        return null;
    }

    private BackpackArmComponent startRelease(BackpackArmComponent arm) {
        class_2487 newState = new class_2487();
        newState.method_10556(KEY_IS_GRABBING, false);
        return arm.startRetracting().withActionState(newState);
    }

    private boolean needsLocomotion(ArmActionContext ctx) {
        return true;
    }

    private boolean shouldYieldArm(ArmActionContext ctx) {
        return false;
    }

    private boolean otherActionsHavePendingTasks(ArmActionContext ctx) {
        if (this.hasPendingAttackTargets(ctx)) {
            return true;
        }
        if (this.hasPendingMiningTasks(ctx)) {
            return true;
        }
        if (this.hasPendingPlacingTasks(ctx)) {
            return true;
        }
        return this.hasPendingPickupItems(ctx);
    }

    private boolean hasPendingAttackTargets(ArmActionContext ctx) {
        if (!ctx.hasUpgrade((class_1792)FTechEquipment.COMBAT_UPGRADE_ITEM.get())) {
            return false;
        }
        if (!ctx.isAttackEnabled()) {
            return false;
        }
        int availableWeaponArms = 0;
        int armsDoingAttack = 0;
        for (BackpackArm arm : BackpackArm.values()) {
            BackpackArmComponent armData = BackpackItem.getArmData(arm, ctx.backpack());
            if (AttackAction.ID.equals((Object)armData.actionType())) {
                ++armsDoingAttack;
                continue;
            }
            class_1799 weapon = BackpackItem.getWeaponForArm(ctx.backpack(), arm);
            if (weapon == null || weapon.method_7960() || !BackpackWeaponSlotsComponent.isValidWeapon(weapon)) continue;
            ++availableWeaponArms;
        }
        if (availableWeaponArms == 0) {
            return false;
        }
        int validTargets = 0;
        double attackRange = 10.0;
        class_243 playerPos = ctx.entity().method_19538();
        List nearbyMobs = ctx.level().method_8390(class_1308.class, new class_238(playerPos.field_1352 - attackRange, playerPos.field_1351 - attackRange, playerPos.field_1350 - attackRange, playerPos.field_1352 + attackRange, playerPos.field_1351 + attackRange, playerPos.field_1350 + attackRange), mob -> mob.method_5805() && !mob.method_5655());
        for (class_1308 mob2 : nearbyMobs) {
            class_243 mobCenter;
            if (!(mob2 instanceof class_1588) && !(mob2 instanceof class_1510) && !(mob2 instanceof class_1593) && !(mob2 instanceof class_4760) || (mobCenter = mob2.method_19538().method_1031(0.0, (double)(mob2.method_17682() / 2.0f), 0.0)).method_1022(playerPos) > attackRange || !ctx.hasLineOfSight(mobCenter)) continue;
            ++validTargets;
        }
        return validTargets > 0 && validTargets * 2 > armsDoingAttack;
    }

    private boolean hasPendingPickupItems(ArmActionContext ctx) {
        if (!ctx.hasUpgrade((class_1792)FTechEquipment.ITEM_PICKUP_UPGRADE_ITEM.get())) {
            return false;
        }
        if (!ctx.isItemPickupEnabled()) {
            return false;
        }
        int availableSpace = ctx.getMaxCapacity() - ctx.getCurrentItemCount();
        if (availableSpace <= 0) {
            return false;
        }
        int armsDoingPickup = 0;
        for (BackpackArm arm : BackpackArm.values()) {
            BackpackArmComponent armData = BackpackItem.getArmData(arm, ctx.backpack());
            if (!PickupAction.ID.equals((Object)armData.actionType())) continue;
            ++armsDoingPickup;
        }
        int validTargets = 0;
        List nearbyItems = ctx.level().method_8390(class_1542.class, ctx.entity().method_5829().method_1014(8.0), item -> item.method_5805() && !item.method_6977());
        for (class_1542 itemEntity : nearbyItems) {
            class_243 itemPos;
            if (itemEntity.method_6983().method_7947() > availableSpace || !ctx.hasLineOfSight(itemPos = itemEntity.method_19538().method_1031(0.0, 0.25, 0.0))) continue;
            ++validTargets;
        }
        return validTargets > armsDoingPickup;
    }

    private boolean hasPendingMiningTasks(ArmActionContext ctx) {
        int availableDrillArms = 0;
        int armsDoingMining = 0;
        for (BackpackArm arm : BackpackArm.values()) {
            BackpackArmComponent armData = BackpackItem.getArmData(arm, ctx.backpack());
            if (MiningAction.ID.equals((Object)armData.actionType())) {
                ++armsDoingMining;
                continue;
            }
            class_1799 drill = BackpackItem.getDrillForArm(ctx.backpack(), arm);
            if (drill == null || drill.method_7960() || !(drill.method_7909() instanceof RoboticDrillItem)) continue;
            ++availableDrillArms;
        }
        if (availableDrillArms == 0) {
            return false;
        }
        int validTargets = 0;
        List<BackpackBuildInstructionComponent> instructions = ctx.buildInstructions();
        class_2338 playerPos = ctx.getPlayerPos();
        for (BackpackBuildInstructionComponent instruction : instructions) {
            class_2338 pos;
            if (!instruction.targetBlockState().method_27852(class_2246.field_10369) || (pos = instruction.blockPos()).method_19455((class_2382)playerPos) > 10 || !ctx.hasLineOfSight(pos)) continue;
            ++validTargets;
        }
        return validTargets > armsDoingMining;
    }

    private boolean hasPendingPlacingTasks(ArmActionContext ctx) {
        int armsDoingPlacing = 0;
        for (BackpackArm arm : BackpackArm.values()) {
            BackpackArmComponent armData = BackpackItem.getArmData(arm, ctx.backpack());
            if (!PlacingAction.ID.equals((Object)armData.actionType())) continue;
            ++armsDoingPlacing;
        }
        int validTargets = 0;
        List<BackpackBuildInstructionComponent> instructions = ctx.buildInstructions();
        class_2338 playerPos = ctx.getPlayerPos();
        for (BackpackBuildInstructionComponent instruction : instructions) {
            class_2338 pos;
            if (instruction.targetBlockState().method_27852(class_2246.field_10369) || (pos = instruction.blockPos()).method_19455((class_2382)playerPos) > 10 || !ctx.hasLineOfSight(pos)) continue;
            class_1792 blockItem = instruction.targetBlockState().method_26204().method_8389();
            boolean hasItem = false;
            for (BackpackItemComponent invItem : BackpackItem.getReadonlyInventory(ctx.backpack(), true)) {
                if (!invItem.item().method_31574(blockItem)) continue;
                hasItem = true;
                break;
            }
            if (!hasItem) continue;
            ++validTargets;
        }
        return validTargets > armsDoingPlacing;
    }

    private boolean isTargetTooCloseToOtherArms(ArmActionContext ctx, class_243 targetPos) {
        double minSpacing = 3.5;
        for (BackpackArm otherArm : BackpackArm.values()) {
            double distance;
            class_243 otherTargetPos;
            BackpackArmComponent otherArmData;
            if (otherArm == ctx.arm() || !ID.equals((Object)(otherArmData = BackpackItem.getArmData(otherArm, ctx.backpack())).actionType()) || otherArmData.direction() == 0 || (otherTargetPos = otherArmData.extendedPos()) == null || !((distance = targetPos.method_1022(otherTargetPos)) < minSpacing)) continue;
            return true;
        }
        return false;
    }

    private int countOtherGrabbingArms(ArmActionContext ctx) {
        int count = 0;
        for (BackpackArm otherArm : BackpackArm.values()) {
            BackpackArmComponent otherArmData;
            if (otherArm == ctx.arm() || !ID.equals((Object)(otherArmData = BackpackItem.getArmData(otherArm, ctx.backpack())).actionType()) || !otherArmData.actionState().method_10577(KEY_IS_GRABBING) || otherArmData.direction() != 2) continue;
            ++count;
        }
        return count;
    }

    private int getArmTier(BackpackArm arm) {
        return switch (arm) {
            default -> throw new IncompatibleClassChangeError();
            case BackpackArm.TOP_LEFT, BackpackArm.TOP_RIGHT -> 0;
            case BackpackArm.TOP_LEFT_UPPER, BackpackArm.TOP_RIGHT_UPPER -> 1;
            case BackpackArm.TOP_LEFT_LOWER, BackpackArm.TOP_RIGHT_LOWER -> 2;
            case BackpackArm.LEFT, BackpackArm.RIGHT -> 3;
        };
    }
}

