/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack.action;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1510;
import net.minecraft.class_1588;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_4760;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArm;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.BackpackWeaponSlotsComponent;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmActionContext;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmTask;
import uk.co.cablepost.ftech_equipment.backpack.action.SwingAction;
import uk.co.cablepost.ftech_equipment.mixin.EntityAccessor;
import uk.co.cablepost.ftech_equipment.mixin.PlayerAccessor;

public class AttackAction
extends SwingAction {
    public static final class_2960 ID = new class_2960("f_tech_equipment", "attack");
    public static final String KEY_TARGET_ENTITY_ID = "targetEntityId";
    public static final String KEY_SWING_START_X = "swingStartX";
    public static final String KEY_SWING_START_Y = "swingStartY";
    public static final String KEY_SWING_START_Z = "swingStartZ";
    public static final String KEY_SWING_END_X = "swingEndX";
    public static final String KEY_SWING_END_Y = "swingEndY";
    public static final String KEY_SWING_END_Z = "swingEndZ";
    private static final double ATTACK_RANGE = 10.0;
    private static final double SWING_HEIGHT_ABOVE_HITBOX = 0.5;
    private static final float ATTACK_SWING_SPEED = 0.3f;
    private static final int MAX_HOVER_TICKS = 1000;
    private static final int MIN_HOVER_TICKS = 2;
    private static final double HOVER_RISE_MAX = 0.7;
    private static final double HOVER_RISE_SPEED = 0.035;
    public static final String KEY_HOVER_TIMER = "hoverTimer";
    public static final String KEY_HOVER_START_TIME = "hoverStartTime";
    private static final double SWING_HORIZONTAL_OFFSET = 1.5;
    public static final int PHASE_HOVER = 10;
    public static final int PHASE_RETURN_TO_HOVER = 11;
    private static final float RETURN_TO_HOVER_SPEED = 0.05f;
    public static final String KEY_SWING_ANGLE = "swingAngle";
    public static final String KEY_SWING_UPWARD = "swingUpward";
    private static final double UPWARD_SWING_THRESHOLD = 2.5;
    private static final float MIN_PROGRESS_FOR_STAGGER = 0.5f;
    private static final int MAX_ARMS_PER_TARGET = 2;

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    protected float getSwingSpeed() {
        return 0.3f;
    }

    @Override
    @Nullable
    public ArmTask findTask(ArmActionContext ctx) {
        if (!ctx.hasUpgrade((class_1792)FTechEquipment.COMBAT_UPGRADE_ITEM.get())) {
            return null;
        }
        if (!ctx.isAttackEnabled()) {
            return null;
        }
        class_1799 weapon = ctx.getWeapon();
        if (weapon == null || weapon.method_7960()) {
            return null;
        }
        if (!BackpackWeaponSlotsComponent.isValidWeapon(weapon)) {
            return null;
        }
        class_243 playerPos = ctx.entity().method_19538();
        List nearbyMobs = ctx.level().method_8390(class_1308.class, new class_238(playerPos.field_1352 - 10.0, playerPos.field_1351 - 10.0, playerPos.field_1350 - 10.0, playerPos.field_1352 + 10.0, playerPos.field_1351 + 10.0, playerPos.field_1350 + 10.0), mob -> mob.method_5805() && !mob.method_5655());
        for (class_1308 mob2 : nearbyMobs) {
            class_243 mobCenter;
            if (!(mob2 instanceof class_1588) && !(mob2 instanceof class_1510) && !(mob2 instanceof class_1593) && !(mob2 instanceof class_4760) || (mobCenter = this.getEntityCenter((class_1297)mob2)).method_1022(playerPos) > 10.0 || !ctx.hasLineOfSight(mobCenter) || this.shouldSkipTarget(ctx, (class_1309)mob2, weapon)) continue;
            float swingAngle = (float)(Math.random() * 180.0);
            double playerEyeY = ctx.entity().method_23320();
            boolean swingUpward = mobCenter.field_1351 > playerEyeY + 2.5;
            class_243 swingEnd = this.calculateSwingEndPosition((class_1297)mob2, mobCenter, ctx.entity().method_19538());
            double entityHeight = this.getEntityHeight((class_1297)mob2);
            double hoverHeight = entityHeight + 0.5;
            double baseY = mobCenter.field_1351 - entityHeight / 2.0;
            class_243 swingStart = this.calculateSwingStartPosition(swingEnd, ctx.entity().method_19538(), baseY, hoverHeight, swingAngle, 0.0, swingUpward);
            class_2487 state = new class_2487();
            state.method_10569(KEY_TARGET_ENTITY_ID, mob2.method_5628());
            state.method_10569("phase", 0);
            state.method_10548("swingProgress", 0.0f);
            state.method_10548(KEY_SWING_ANGLE, swingAngle);
            state.method_10556(KEY_SWING_UPWARD, swingUpward);
            state.method_10549(KEY_SWING_START_X, swingStart.field_1352);
            state.method_10549(KEY_SWING_START_Y, swingStart.field_1351);
            state.method_10549(KEY_SWING_START_Z, swingStart.field_1350);
            state.method_10549(KEY_SWING_END_X, swingEnd.field_1352);
            state.method_10549(KEY_SWING_END_Y, swingEnd.field_1351);
            state.method_10549(KEY_SWING_END_Z, swingEnd.field_1350);
            return new ArmTask(swingStart, weapon.method_7972(), state);
        }
        return null;
    }

    @Override
    @Nullable
    public BackpackArmComponent tick(ArmActionContext ctx) {
        BackpackArmComponent arm = ctx.armData();
        class_2487 state = arm.actionState().method_10553();
        int phase = state.method_10550("phase");
        if (phase == 0) {
            if (arm.progress() >= 0.99f) {
                state.method_10569("phase", 10);
                state.method_10569(KEY_HOVER_TIMER, 0);
                state.method_10544(KEY_HOVER_START_TIME, ctx.level().method_8510());
                return arm.withActionState(state);
            }
            return this.onExtending(ctx);
        }
        if (phase == 10) {
            int hoverTicks = state.method_10550(KEY_HOVER_TIMER) + 1;
            state.method_10569(KEY_HOVER_TIMER, hoverTicks);
            if (!ctx.isAttackEnabled()) {
                return arm.startRetracting().withHolding(ctx.getWeapon()).withActionState(new class_2487());
            }
            int targetEntityId = state.method_10550(KEY_TARGET_ENTITY_ID);
            class_1297 target = ctx.level().method_8469(targetEntityId);
            if (target == null || !target.method_5805()) {
                return arm.startRetracting().withHolding(ctx.getWeapon()).withActionState(new class_2487());
            }
            class_243 targetPos = this.getEntityCenter(target);
            if (targetPos.method_1022(ctx.entity().method_19538()) > 10.0) {
                return arm.startRetracting().withHolding(ctx.getWeapon()).withActionState(new class_2487());
            }
            if (!ctx.hasLineOfSight(targetPos)) {
                return arm.startRetracting().withHolding(ctx.getWeapon()).withActionState(new class_2487());
            }
            boolean shouldStrike = false;
            if (hoverTicks >= 1000) {
                shouldStrike = true;
            } else if (hoverTicks >= 2) {
                shouldStrike = this.isMobReadyToAttack(target, ctx);
            }
            if (shouldStrike) {
                state.method_10569("phase", 1);
                state.method_10548("swingProgress", 0.0f);
                return arm.withActionState(state);
            }
            class_243 mobCenter = this.getEntityCenter(target);
            class_243 swingEnd = this.calculateSwingEndPosition(target, mobCenter, ctx.entity().method_19538());
            double entityHeight = this.getEntityHeight(target);
            double hoverHeight = entityHeight + 0.5;
            double hoverRise = Math.min((double)hoverTicks * 0.035, 0.7);
            float swingAngle = state.method_10583(KEY_SWING_ANGLE);
            boolean swingUpward = state.method_10577(KEY_SWING_UPWARD);
            double baseY = mobCenter.field_1351 - entityHeight / 2.0;
            class_243 swingStart = this.calculateSwingStartPosition(swingEnd, ctx.entity().method_19538(), baseY, hoverHeight, swingAngle, hoverRise, swingUpward);
            state.method_10549(KEY_SWING_START_X, swingStart.field_1352);
            state.method_10549(KEY_SWING_START_Y, swingStart.field_1351);
            state.method_10549(KEY_SWING_START_Z, swingStart.field_1350);
            state.method_10549(KEY_SWING_END_X, swingEnd.field_1352);
            state.method_10549(KEY_SWING_END_Y, swingEnd.field_1351);
            state.method_10549(KEY_SWING_END_Z, swingEnd.field_1350);
            return arm.withExtendedPos(swingStart).withActionState(state);
        }
        if (phase == 1) {
            class_243 swingEnd;
            float swingProgress = state.method_10583("swingProgress") + this.getSwingSpeed();
            int targetEntityId = state.method_10550(KEY_TARGET_ENTITY_ID);
            class_1297 target = ctx.level().method_8469(targetEntityId);
            if (target != null && target.method_5805()) {
                class_243 mobCenter = this.getEntityCenter(target);
                swingEnd = this.calculateSwingEndPosition(target, mobCenter, ctx.entity().method_19538());
                state.method_10549(KEY_SWING_END_X, swingEnd.field_1352);
                state.method_10549(KEY_SWING_END_Y, swingEnd.field_1351);
                state.method_10549(KEY_SWING_END_Z, swingEnd.field_1350);
            } else {
                swingEnd = new class_243(state.method_10574(KEY_SWING_END_X), state.method_10574(KEY_SWING_END_Y), state.method_10574(KEY_SWING_END_Z));
            }
            if (swingProgress >= 1.0f) {
                this.onSwingComplete(ctx);
                if (target != null && target.method_5805() && target instanceof class_1309) {
                    class_1309 livingTarget = (class_1309)target;
                    state.method_10569("phase", 11);
                    state.method_10548("swingProgress", 0.0f);
                    state.method_10548(KEY_SWING_ANGLE, (float)(Math.random() * 180.0));
                    return arm.withExtendedPos(swingEnd).withActionState(state);
                }
                state.method_10569("phase", 2);
                state.method_10548("swingProgress", 1.0f);
                return arm.withExtendedPos(swingEnd).withDirection(0).withActionState(state);
            }
            class_243 swingStart = new class_243(state.method_10574(KEY_SWING_START_X), state.method_10574(KEY_SWING_START_Y), state.method_10574(KEY_SWING_START_Z));
            float easedProgress = swingProgress * swingProgress;
            class_243 currentPos = swingStart.method_35590(swingEnd, (double)easedProgress);
            state.method_10548("swingProgress", swingProgress);
            return arm.withExtendedPos(currentPos).withActionState(state);
        }
        if (phase == 11) {
            float returnProgress = state.method_10583("swingProgress") + 0.05f;
            if (!ctx.isAttackEnabled()) {
                return arm.startRetracting().withHolding(ctx.getWeapon()).withActionState(new class_2487());
            }
            int targetEntityId = state.method_10550(KEY_TARGET_ENTITY_ID);
            class_1297 target = ctx.level().method_8469(targetEntityId);
            if (target == null || !target.method_5805()) {
                return arm.startRetracting().withHolding(ctx.getWeapon()).withActionState(new class_2487());
            }
            class_243 targetPos = this.getEntityCenter(target);
            if (targetPos.method_1022(ctx.entity().method_19538()) > 10.0) {
                return arm.startRetracting().withHolding(ctx.getWeapon()).withActionState(new class_2487());
            }
            if (!ctx.hasLineOfSight(targetPos)) {
                return arm.startRetracting().withHolding(ctx.getWeapon()).withActionState(new class_2487());
            }
            class_243 mobCenter = this.getEntityCenter(target);
            class_243 swingEnd = this.calculateSwingEndPosition(target, mobCenter, ctx.entity().method_19538());
            double entityHeight = this.getEntityHeight(target);
            double hoverHeight = entityHeight + 0.5;
            float swingAngle = state.method_10583(KEY_SWING_ANGLE);
            double playerEyeY = ctx.entity().method_23320();
            boolean swingUpward = mobCenter.field_1351 > playerEyeY + 2.5;
            state.method_10556(KEY_SWING_UPWARD, swingUpward);
            double baseY = mobCenter.field_1351 - entityHeight / 2.0;
            class_243 hoverPos = this.calculateSwingStartPosition(swingEnd, ctx.entity().method_19538(), baseY, hoverHeight, swingAngle, 0.0, swingUpward);
            class_243 currentArmPos = arm.extendedPos();
            if (returnProgress >= 1.0f) {
                state.method_10569("phase", 10);
                state.method_10569(KEY_HOVER_TIMER, 0);
                state.method_10544(KEY_HOVER_START_TIME, ctx.level().method_8510());
                state.method_10549(KEY_SWING_START_X, hoverPos.field_1352);
                state.method_10549(KEY_SWING_START_Y, hoverPos.field_1351);
                state.method_10549(KEY_SWING_START_Z, hoverPos.field_1350);
                state.method_10549(KEY_SWING_END_X, swingEnd.field_1352);
                state.method_10549(KEY_SWING_END_Y, swingEnd.field_1351);
                state.method_10549(KEY_SWING_END_Z, swingEnd.field_1350);
                return arm.withExtendedPos(hoverPos).withActionState(state);
            }
            class_243 newPos = currentArmPos.method_35590(hoverPos, (double)returnProgress);
            state.method_10548("swingProgress", returnProgress);
            return arm.withExtendedPos(newPos).withActionState(state);
        }
        return super.tick(ctx);
    }

    @Override
    @Nullable
    protected BackpackArmComponent onExtending(ArmActionContext ctx) {
        BackpackArmComponent arm = ctx.armData();
        int targetEntityId = arm.actionState().method_10550(KEY_TARGET_ENTITY_ID);
        class_1297 target = ctx.level().method_8469(targetEntityId);
        if (target == null || !target.method_5805()) {
            return arm.startRetracting().withHolding(ctx.getWeapon()).withActionState(new class_2487());
        }
        class_243 mobCenter = this.getEntityCenter(target);
        if (mobCenter.method_1022(ctx.entity().method_19538()) > 20.0) {
            return arm.startRetracting().withHolding(ctx.getWeapon()).withActionState(new class_2487());
        }
        class_243 swingEnd = this.calculateSwingEndPosition(target, mobCenter, ctx.entity().method_19538());
        double entityHeight = this.getEntityHeight(target);
        double hoverHeight = entityHeight + 0.5;
        class_2487 state = arm.actionState().method_10553();
        float swingAngle = state.method_10583(KEY_SWING_ANGLE);
        boolean swingUpward = state.method_10577(KEY_SWING_UPWARD);
        double baseY = mobCenter.field_1351 - entityHeight / 2.0;
        class_243 swingStart = this.calculateSwingStartPosition(swingEnd, ctx.entity().method_19538(), baseY, hoverHeight, swingAngle, 0.0, swingUpward);
        state.method_10549(KEY_SWING_START_X, swingStart.field_1352);
        state.method_10549(KEY_SWING_START_Y, swingStart.field_1351);
        state.method_10549(KEY_SWING_START_Z, swingStart.field_1350);
        state.method_10549(KEY_SWING_END_X, swingEnd.field_1352);
        state.method_10549(KEY_SWING_END_Y, swingEnd.field_1351);
        state.method_10549(KEY_SWING_END_Z, swingEnd.field_1350);
        return arm.withExtendedPos(swingStart).withActionState(state);
    }

    @Override
    protected void onSwingComplete(ArmActionContext ctx) {
        BackpackArmComponent arm = ctx.armData();
        int targetEntityId = arm.actionState().method_10550(KEY_TARGET_ENTITY_ID);
        class_1297 target = ctx.level().method_8469(targetEntityId);
        if (target == null || !target.method_5805()) {
            return;
        }
        class_1799 weapon = ctx.getWeapon();
        if (weapon == null || weapon.method_7960()) {
            return;
        }
        class_1309 class_13092 = ctx.entity();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            class_1799 originalMainhand = player.method_6047().method_7972();
            if (!originalMainhand.method_7960()) {
                player.method_6127().method_26847(originalMainhand.method_7926(class_1304.field_6173));
            }
            player.method_31548().method_5447(player.method_31548().field_7545, weapon);
            if (!weapon.method_7960()) {
                player.method_6127().method_26854(weapon.method_7926(class_1304.field_6173));
            }
            PlayerAccessor playerAttackAccessor = (PlayerAccessor)player;
            int lastAttackedTicksBefore = playerAttackAccessor.getAttackStrengthTicker();
            playerAttackAccessor.setAttackStrengthTicker(9999);
            class_2487 state = ctx.armData().actionState();
            class_243 armPosition = new class_243(state.method_10574(KEY_SWING_END_X), state.method_10574(KEY_SWING_END_Y), state.method_10574(KEY_SWING_END_Z));
            EntityAccessor playerAccessor = (EntityAccessor)player;
            class_243 originalPosition = playerAccessor.getPositionDirect();
            playerAccessor.setPositionDirect(armPosition);
            player.method_7324(target);
            playerAccessor.setPositionDirect(originalPosition);
            class_1799 weaponAfterAttack = player.method_6047();
            if (!weaponAfterAttack.method_7960()) {
                player.method_6127().method_26847(weaponAfterAttack.method_7926(class_1304.field_6173));
            }
            player.method_31548().method_5447(player.method_31548().field_7545, originalMainhand);
            playerAttackAccessor.setAttackStrengthTicker(lastAttackedTicksBefore);
            if (!originalMainhand.method_7960()) {
                player.method_6127().method_26854(originalMainhand.method_7926(class_1304.field_6173));
            }
            if (weaponAfterAttack.method_7960()) {
                ctx.setWeapon(class_1799.field_8037);
            } else {
                ctx.setWeapon(weaponAfterAttack);
            }
        }
    }

    @Override
    @Nullable
    protected BackpackArmComponent onRetracted(ArmActionContext ctx) {
        return ctx.armData().withActionType(null).withActionState(new class_2487()).withProgress(0.0f).withDirection(0);
    }

    private float estimateWeaponDamage(class_1799 weapon) {
        if (weapon == null || weapon.method_7960()) {
            return 0.0f;
        }
        Multimap modifiers = weapon.method_7926(class_1304.field_6173);
        Collection damageModifiers = modifiers.get((Object)class_5134.field_23721);
        float totalDamage = 1.0f;
        for (class_1322 modifier : damageModifiers) {
            if (modifier.method_6182() != class_1322.class_1323.field_6328) continue;
            totalDamage += (float)modifier.method_6186();
        }
        return totalDamage;
    }

    private boolean shouldSkipTarget(ArmActionContext ctx, class_1309 target, class_1799 ourWeapon) {
        int minArmsOnOtherTargets;
        int entityId = target.method_5628();
        float pendingDamage = 0.0f;
        float lowestProgress = 1.0f;
        int armsTargetingMob = 0;
        HashMap<Integer, Integer> armsPerTarget = new HashMap<Integer, Integer>();
        for (BackpackArm otherArm : BackpackArm.values()) {
            class_1799 otherWeapon;
            BackpackArmComponent otherArmData;
            if (otherArm == ctx.arm() || !ID.equals((Object)(otherArmData = BackpackItem.getArmData(otherArm, ctx.backpack())).actionType())) continue;
            int targetId = otherArmData.actionState().method_10550(KEY_TARGET_ENTITY_ID);
            armsPerTarget.merge(targetId, 1, Integer::sum);
            if (targetId != entityId) continue;
            ++armsTargetingMob;
            if (otherArmData.progress() < lowestProgress) {
                lowestProgress = otherArmData.progress();
            }
            if ((otherWeapon = BackpackItem.getWeaponForArm(ctx.backpack(), otherArm)) == null || otherWeapon.method_7960()) continue;
            pendingDamage += this.estimateWeaponDamage(otherWeapon);
        }
        if (armsTargetingMob >= 2) {
            return true;
        }
        if (lowestProgress < 0.5f) {
            return true;
        }
        float mobHealth = target.method_6032();
        if (pendingDamage >= mobHealth) {
            return true;
        }
        return armsTargetingMob > 0 && (minArmsOnOtherTargets = this.findMinArmsOnOtherValidTargets(ctx, entityId, armsPerTarget)) < armsTargetingMob;
    }

    private int findMinArmsOnOtherValidTargets(ArmActionContext ctx, int excludeEntityId, Map<Integer, Integer> armsPerTarget) {
        class_243 playerPos = ctx.entity().method_19538();
        int minArms = Integer.MAX_VALUE;
        List nearbyMobs = ctx.level().method_8390(class_1308.class, new class_238(playerPos.field_1352 - 10.0, playerPos.field_1351 - 10.0, playerPos.field_1350 - 10.0, playerPos.field_1352 + 10.0, playerPos.field_1351 + 10.0, playerPos.field_1350 + 10.0), mob -> mob.method_5805() && !mob.method_5655() && mob.method_5628() != excludeEntityId);
        for (class_1308 mob2 : nearbyMobs) {
            int armsOnThis;
            class_243 mobCenter;
            if (!(mob2 instanceof class_1588) && !(mob2 instanceof class_1510) || (mobCenter = this.getEntityCenter((class_1297)mob2)).method_1022(playerPos) > 10.0 || !ctx.hasLineOfSight(mobCenter) || (armsOnThis = armsPerTarget.getOrDefault(mob2.method_5628(), 0).intValue()) >= minArms) continue;
            minArms = armsOnThis;
        }
        return minArms;
    }

    private class_243 calculateSwingEndPosition(class_1297 target, class_243 mobCenter, class_243 playerPos) {
        float mobWidth = target.method_17681();
        class_243 toPlayer = new class_243(playerPos.field_1352 - mobCenter.field_1352, 0.0, playerPos.field_1350 - mobCenter.field_1350);
        double distance = toPlayer.method_37267();
        if (distance > 0.01) {
            double offsetAmount = Math.min((double)(mobWidth * 0.9f), distance * 0.5);
            class_243 offset = toPlayer.method_18805(1.0 / distance, 1.0 / distance, 1.0 / distance).method_18805(offsetAmount, offsetAmount, offsetAmount);
            return mobCenter.method_1019(offset);
        }
        return mobCenter;
    }

    private class_243 calculateSwingStartPosition(class_243 swingEnd, class_243 playerPos, double baseY, double hoverHeight, float swingAngle, double hoverRise, boolean swingUpward) {
        class_243 toPlayer = new class_243(playerPos.field_1352 - swingEnd.field_1352, 0.0, playerPos.field_1350 - swingEnd.field_1350).method_1029();
        class_243 perpendicular = new class_243(-toPlayer.field_1350, 0.0, toPlayer.field_1352);
        double offsetFactor = Math.cos(Math.toRadians(swingAngle));
        class_243 horizontalOffset = perpendicular.method_18805(1.5 * offsetFactor, 1.5 * offsetFactor, 1.5 * offsetFactor);
        double hoverY = swingUpward ? baseY - hoverRise : baseY + hoverHeight + hoverRise;
        return new class_243(swingEnd.field_1352 + horizontalOffset.field_1352, hoverY, swingEnd.field_1350 + horizontalOffset.field_1350);
    }

    private class_243 getEntityCenter(class_1297 entity) {
        if (entity instanceof class_1510) {
            class_1510 dragon = (class_1510)entity;
            class_238 box = dragon.method_5829();
            double targetY = box.field_1322 + (box.field_1325 - box.field_1322) * (double)0.4f;
            return new class_243(box.method_1005().field_1352, targetY, box.method_1005().field_1350);
        }
        return entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0);
    }

    private double getEntityHeight(class_1297 entity) {
        if (entity instanceof class_1510) {
            class_1510 dragon = (class_1510)entity;
            class_238 box = dragon.method_5829();
            return (box.field_1325 - box.field_1322) * (double)0.4f;
        }
        return entity.method_17682();
    }

    private boolean isMobReadyToAttack(class_1297 target, ArmActionContext ctx) {
        if (target instanceof class_1308) {
            class_1308 mob = (class_1308)target;
            if (mob.field_6235 > 3) {
                return false;
            }
            return !this.isAnotherArmSwingingAtTarget(ctx, target.method_5628());
        }
        return true;
    }

    private boolean isAnotherArmSwingingAtTarget(ArmActionContext ctx, int entityId) {
        for (BackpackArm otherArm : BackpackArm.values()) {
            int phase;
            int targetId;
            BackpackArmComponent otherArmData;
            if (otherArm == ctx.arm() || !ID.equals((Object)(otherArmData = BackpackItem.getArmData(otherArm, ctx.backpack())).actionType()) || (targetId = otherArmData.actionState().method_10550(KEY_TARGET_ENTITY_ID)) != entityId || (phase = otherArmData.actionState().method_10550("phase")) != 1) continue;
            return true;
        }
        return false;
    }
}

