/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack.action;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmAction;

public final class ArmActionRegistry {
    private static final Map<class_2960, ArmAction> ACTIONS = new HashMap<class_2960, ArmAction>();
    private static List<ArmAction> SORTED_BY_PRIORITY = new ArrayList<ArmAction>();

    private ArmActionRegistry() {
    }

    public static void register(ArmAction action) {
        ACTIONS.put(action.getId(), action);
        ArmActionRegistry.rebuildPriorityList();
    }

    @Nullable
    public static ArmAction get(class_2960 id) {
        if (id == null) {
            return null;
        }
        return ACTIONS.get(id);
    }

    public static List<ArmAction> getByPriority() {
        return SORTED_BY_PRIORITY;
    }

    public static Iterable<ArmAction> getAll() {
        return ACTIONS.values();
    }

    private static void rebuildPriorityList() {
        SORTED_BY_PRIORITY = new ArrayList<ArmAction>(ACTIONS.values());
        SORTED_BY_PRIORITY.sort(Comparator.comparingInt(ArmAction::getPriority).reversed());
    }
}

