/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5134;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArm;

public record BackpackWeaponSlotsComponent(class_1799 topLeft, class_1799 topLeftUpper, class_1799 topLeftLower, class_1799 left, class_1799 topRight, class_1799 topRightUpper, class_1799 topRightLower, class_1799 right) {
    public static final BackpackWeaponSlotsComponent EMPTY = new BackpackWeaponSlotsComponent(class_1799.field_8037, class_1799.field_8037, class_1799.field_8037, class_1799.field_8037, class_1799.field_8037, class_1799.field_8037, class_1799.field_8037, class_1799.field_8037);
    private static final double MIN_ATTACK_DAMAGE = 1.0;

    public static boolean isValidWeapon(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        Multimap modifiers = stack.method_7926(class_1304.field_6173);
        Collection damageModifiers = modifiers.get((Object)class_5134.field_23721);
        for (class_1322 modifier : damageModifiers) {
            if (modifier.method_6182() != class_1322.class_1323.field_6328 || !(modifier.method_6186() >= 1.0)) continue;
            return true;
        }
        return false;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("topLeft", (class_2520)this.topLeft.method_7953(new class_2487()));
        nbt.method_10566("topLeftUpper", (class_2520)this.topLeftUpper.method_7953(new class_2487()));
        nbt.method_10566("topLeftLower", (class_2520)this.topLeftLower.method_7953(new class_2487()));
        nbt.method_10566("left", (class_2520)this.left.method_7953(new class_2487()));
        nbt.method_10566("topRight", (class_2520)this.topRight.method_7953(new class_2487()));
        nbt.method_10566("topRightUpper", (class_2520)this.topRightUpper.method_7953(new class_2487()));
        nbt.method_10566("topRightLower", (class_2520)this.topRightLower.method_7953(new class_2487()));
        nbt.method_10566("right", (class_2520)this.right.method_7953(new class_2487()));
        return nbt;
    }

    public static BackpackWeaponSlotsComponent fromNbt(class_2487 nbt) {
        return new BackpackWeaponSlotsComponent(class_1799.method_7915((class_2487)nbt.method_10562("topLeft")), class_1799.method_7915((class_2487)nbt.method_10562("topLeftUpper")), class_1799.method_7915((class_2487)nbt.method_10562("topLeftLower")), class_1799.method_7915((class_2487)nbt.method_10562("left")), class_1799.method_7915((class_2487)nbt.method_10562("topRight")), class_1799.method_7915((class_2487)nbt.method_10562("topRightUpper")), class_1799.method_7915((class_2487)nbt.method_10562("topRightLower")), class_1799.method_7915((class_2487)nbt.method_10562("right")));
    }

    public class_1799 getWeaponForArm(BackpackArm arm) {
        return switch (arm) {
            default -> throw new IncompatibleClassChangeError();
            case BackpackArm.TOP_LEFT -> this.topLeft;
            case BackpackArm.TOP_LEFT_UPPER -> this.topLeftUpper;
            case BackpackArm.TOP_LEFT_LOWER -> this.topLeftLower;
            case BackpackArm.LEFT -> this.left;
            case BackpackArm.TOP_RIGHT -> this.topRight;
            case BackpackArm.TOP_RIGHT_UPPER -> this.topRightUpper;
            case BackpackArm.TOP_RIGHT_LOWER -> this.topRightLower;
            case BackpackArm.RIGHT -> this.right;
        };
    }

    public BackpackWeaponSlotsComponent setWeaponForArm(BackpackArm arm, class_1799 weapon) {
        return switch (arm) {
            default -> throw new IncompatibleClassChangeError();
            case BackpackArm.TOP_LEFT -> new BackpackWeaponSlotsComponent(weapon, this.topLeftUpper, this.topLeftLower, this.left, this.topRight, this.topRightUpper, this.topRightLower, this.right);
            case BackpackArm.TOP_LEFT_UPPER -> new BackpackWeaponSlotsComponent(this.topLeft, weapon, this.topLeftLower, this.left, this.topRight, this.topRightUpper, this.topRightLower, this.right);
            case BackpackArm.TOP_LEFT_LOWER -> new BackpackWeaponSlotsComponent(this.topLeft, this.topLeftUpper, weapon, this.left, this.topRight, this.topRightUpper, this.topRightLower, this.right);
            case BackpackArm.LEFT -> new BackpackWeaponSlotsComponent(this.topLeft, this.topLeftUpper, this.topLeftLower, weapon, this.topRight, this.topRightUpper, this.topRightLower, this.right);
            case BackpackArm.TOP_RIGHT -> new BackpackWeaponSlotsComponent(this.topLeft, this.topLeftUpper, this.topLeftLower, this.left, weapon, this.topRightUpper, this.topRightLower, this.right);
            case BackpackArm.TOP_RIGHT_UPPER -> new BackpackWeaponSlotsComponent(this.topLeft, this.topLeftUpper, this.topLeftLower, this.left, this.topRight, weapon, this.topRightLower, this.right);
            case BackpackArm.TOP_RIGHT_LOWER -> new BackpackWeaponSlotsComponent(this.topLeft, this.topLeftUpper, this.topLeftLower, this.left, this.topRight, this.topRightUpper, weapon, this.right);
            case BackpackArm.RIGHT -> new BackpackWeaponSlotsComponent(this.topLeft, this.topLeftUpper, this.topLeftLower, this.left, this.topRight, this.topRightUpper, this.topRightLower, weapon);
        };
    }

    public List<class_1799> asList() {
        return List.of(this.topLeft, this.topLeftUpper, this.topLeftLower, this.left, this.topRight, this.topRightUpper, this.topRightLower, this.right);
    }

    public boolean hasAnyWeapons() {
        return !this.topLeft.method_7960() || !this.topLeftUpper.method_7960() || !this.topLeftLower.method_7960() || !this.left.method_7960() || !this.topRight.method_7960() || !this.topRightUpper.method_7960() || !this.topRightLower.method_7960() || !this.right.method_7960();
    }
}

