/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5632;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import uk.co.cablepost.ftech_equipment.FTechEquipment;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArm;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackArmPath;
import uk.co.cablepost.ftech_equipment.backpack.BackpackBuildInstructionComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackDrillSlotsComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackUpgradeSlotsComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackWeaponSlotsComponent;
import uk.co.cablepost.ftech_equipment.backpack.RoboticDrillItem;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmAction;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmActionContext;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmActionRegistry;
import uk.co.cablepost.ftech_equipment.backpack.action.ArmTask;
import uk.co.cablepost.ftech_equipment.backpack.build_instructions_client.BackpackBuildInstructionsReplicateParamsComponent;
import uk.co.cablepost.ftech_equipment.backpack.inventory.BackpackItemComponent;
import uk.co.cablepost.ftech_equipment.backpack.inventory.BackpackTooltip;
import uk.co.cablepost.ftech_equipment.backpack.locomotion.LocomotionController;
import uk.co.cablepost.ftech_equipment.backpack.upgrade.RangeUpgradeItem;
import uk.co.cablepost.ftech_equipment.backpack.upgrade.StorageUpgradeItem;
import uk.co.cablepost.ftech_equipment.platform.EquipmentSlotHelper;
import uk.co.cablepost.ftech_equipment.platform.Services;

public class BackpackItem
extends class_1792 {
    public static class_2960 IDENTIFIER = new class_2960("f_tech_equipment", "backpack");
    private static final float ARM_STEP = 0.06f;
    public static final int BASE_CAPACITY = 1000;
    public static final int BASE_MAX_RANGE = 1;
    private static final Map<String, double[]> closestBlockDistanceCache = new HashMap<String, double[]>();
    private static final Map<String, Double> smoothedClosestBlockDistance = new HashMap<String, Double>();
    private static final double BLOCK_DISTANCE_SMOOTH_FACTOR = 0.15;
    private static final double OPEN_SPACE_BALANCE = (double)0.96f;
    private static final double CONFINED_SPACE_BALANCE = (double)0.93f;
    private static final double CONFINED_THRESHOLD = 2.0;
    private static final double OPEN_THRESHOLD = 5.0;
    private static final double ARM_REACH_CLOSE_THRESHOLD = 3.0;

    public BackpackItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        EquipmentSlotHelper.equipBackpack((class_1309)player, player.method_5998(interactionHand));
        return super.method_7836(level, player, interactionHand);
    }

    public Optional<class_5632> method_32346(class_1799 itemStack) {
        List<class_1799> upgradesList = BackpackItem.getUpgradeSlots(itemStack).asList();
        return Optional.of(new BackpackTooltip(upgradesList));
    }

    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> list, class_1836 tooltipFlag) {
        list.add((class_2561)class_2561.method_43469((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{BackpackItem.getCurrentItemCount(itemStack), BackpackItem.getMaxCapacity(itemStack)}).method_27692(class_124.field_1080));
    }

    public boolean method_31567(class_1799 itemStack) {
        return BackpackItem.getCurrentItemCount(itemStack) > 0;
    }

    public int method_31569(class_1799 itemStack) {
        return BackpackItem.getCurrentItemCount(itemStack) / (BackpackItem.getMaxCapacity(itemStack) / 13);
    }

    public int method_31571(class_1799 itemStack) {
        return 7305922;
    }

    private static class_2487 getOrCreateBackpackNbt(class_1799 stack) {
        return stack.method_7948();
    }

    private static String getArmNbtKey(BackpackArm arm) {
        return switch (arm) {
            default -> throw new IncompatibleClassChangeError();
            case BackpackArm.TOP_LEFT -> "arm_top_left";
            case BackpackArm.TOP_LEFT_UPPER -> "arm_top_left_upper";
            case BackpackArm.TOP_LEFT_LOWER -> "arm_top_left_lower";
            case BackpackArm.LEFT -> "arm_left";
            case BackpackArm.TOP_RIGHT -> "arm_top_right";
            case BackpackArm.TOP_RIGHT_UPPER -> "arm_top_right_upper";
            case BackpackArm.TOP_RIGHT_LOWER -> "arm_top_right_lower";
            case BackpackArm.RIGHT -> "arm_right";
        };
    }

    public static BackpackArmComponent getArmData(BackpackArm backpackArm, class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545(BackpackItem.getArmNbtKey(backpackArm))) {
            return BackpackArmComponent.getDefault();
        }
        return BackpackArmComponent.fromNbt(nbt.method_10562(BackpackItem.getArmNbtKey(backpackArm)));
    }

    public static void setArmData(BackpackArm backpackArm, class_1799 stack, BackpackArmComponent newData) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(stack);
        nbt.method_10566(BackpackItem.getArmNbtKey(backpackArm), (class_2520)newData.toNbt());
    }

    public static List<BackpackBuildInstructionComponent> getBuildInstructions(class_1799 itemStack) {
        class_2487 nbt = itemStack.method_7969();
        if (nbt == null || !nbt.method_10545("build_instructions")) {
            return new ArrayList<BackpackBuildInstructionComponent>();
        }
        class_2499 list = nbt.method_10554("build_instructions", 10);
        ArrayList<BackpackBuildInstructionComponent> result = new ArrayList<BackpackBuildInstructionComponent>();
        for (int i = 0; i < list.size(); ++i) {
            result.add(BackpackBuildInstructionComponent.fromNbt(list.method_10602(i)));
        }
        return result;
    }

    private static void setBuildInstructions(class_1799 itemStack, List<BackpackBuildInstructionComponent> instructions) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(itemStack);
        class_2499 list = new class_2499();
        for (BackpackBuildInstructionComponent instruction : instructions) {
            list.add((Object)instruction.toNbt());
        }
        nbt.method_10566("build_instructions", (class_2520)list);
    }

    public static void addBuildInstructions(class_1799 itemStack, List<BackpackBuildInstructionComponent> instructions) {
        ArrayList<BackpackBuildInstructionComponent> buildInstructions = new ArrayList<BackpackBuildInstructionComponent>(BackpackItem.getBuildInstructions(itemStack));
        List<class_2338> blockPosList = instructions.stream().map(BackpackBuildInstructionComponent::blockPos).toList();
        buildInstructions.removeIf(x -> blockPosList.contains(x.blockPos()));
        buildInstructions.addAll(instructions);
        BackpackItem.setBuildInstructions(itemStack, buildInstructions);
    }

    public static void clearBuildInstructions(class_1799 itemStack) {
        BackpackItem.setBuildInstructions(itemStack, new ArrayList<BackpackBuildInstructionComponent>());
    }

    public static BackpackBuildInstructionsReplicateParamsComponent getReplicateParams(class_1309 player) {
        return BackpackItem.getReplicateParams(FTechEquipment.getBackpackOnPlayer(player));
    }

    public static BackpackBuildInstructionsReplicateParamsComponent getReplicateParams(class_1799 itemStack) {
        if (itemStack == null) {
            return BackpackBuildInstructionsReplicateParamsComponent.getDefault();
        }
        class_2487 nbt = itemStack.method_7969();
        if (nbt == null || !nbt.method_10545("build_instructions_replicate")) {
            return BackpackBuildInstructionsReplicateParamsComponent.getDefault();
        }
        return BackpackBuildInstructionsReplicateParamsComponent.fromNbt(nbt.method_10562("build_instructions_replicate"));
    }

    public static void setReplicateParams(class_1799 itemStack, BackpackBuildInstructionsReplicateParamsComponent params) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(itemStack);
        nbt.method_10566("build_instructions_replicate", (class_2520)params.toNbt());
    }

    public static List<BackpackItemComponent> getReadonlyInventory(class_1799 backpack, boolean removeEmpties) {
        class_2487 nbt = backpack.method_7969();
        ArrayList<BackpackItemComponent> result = new ArrayList<BackpackItemComponent>();
        if (nbt != null && nbt.method_10545("items")) {
            class_2499 list = nbt.method_10554("items", 10);
            for (int i = 0; i < list.size(); ++i) {
                result.add(BackpackItemComponent.fromNbt(list.method_10602(i)));
            }
        }
        if (removeEmpties && result.removeIf(x -> x.count() == 0)) {
            BackpackItem.setInventory(backpack, result);
            BackpackItem.setMetaComponent(backpack, new BackpackComponent(Instant.now().toEpochMilli()));
        }
        result.sort(Comparator.comparing(x -> x.item().method_7964().getString()));
        return result;
    }

    private static void setInventory(class_1799 backpack, List<BackpackItemComponent> inventory) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(backpack);
        class_2499 list = new class_2499();
        for (BackpackItemComponent item : inventory) {
            list.add((Object)item.toNbt());
        }
        nbt.method_10566("items", (class_2520)list);
    }

    public static BackpackComponent getMetaComponent(class_1799 backpack) {
        class_2487 nbt = backpack.method_7969();
        if (nbt == null || !nbt.method_10545("backpack")) {
            return BackpackComponent.getDefault();
        }
        return BackpackComponent.fromNbt(nbt.method_10562("backpack"));
    }

    private static void setMetaComponent(class_1799 backpack, BackpackComponent component) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(backpack);
        nbt.method_10566("backpack", (class_2520)component.toNbt());
    }

    public static BackpackDrillSlotsComponent getDrillSlots(class_1799 backpack) {
        class_2487 nbt = backpack.method_7969();
        if (nbt == null || !nbt.method_10545("drill_slots")) {
            return BackpackDrillSlotsComponent.EMPTY;
        }
        return BackpackDrillSlotsComponent.fromNbt(nbt.method_10562("drill_slots"));
    }

    public static void setDrillSlots(class_1799 backpack, BackpackDrillSlotsComponent drillSlots) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(backpack);
        nbt.method_10566("drill_slots", (class_2520)drillSlots.toNbt());
        BackpackItem.setMetaComponent(backpack, new BackpackComponent(Instant.now().toEpochMilli()));
    }

    public static class_1799 getDrillForArm(class_1799 backpack, BackpackArm arm) {
        return BackpackItem.getDrillSlots(backpack).getDrillForArm(arm);
    }

    public static void setDrillForArm(class_1799 backpack, BackpackArm arm, class_1799 drill) {
        BackpackItem.setDrillSlots(backpack, BackpackItem.getDrillSlots(backpack).setDrillForArm(arm, drill));
    }

    public static boolean hasAnyDrills(class_1799 backpack) {
        return BackpackItem.getDrillSlots(backpack).hasAnyDrills();
    }

    public static BackpackWeaponSlotsComponent getWeaponSlots(class_1799 backpack) {
        class_2487 nbt = backpack.method_7969();
        if (nbt == null || !nbt.method_10545("weapon_slots")) {
            return BackpackWeaponSlotsComponent.EMPTY;
        }
        return BackpackWeaponSlotsComponent.fromNbt(nbt.method_10562("weapon_slots"));
    }

    public static void setWeaponSlots(class_1799 backpack, BackpackWeaponSlotsComponent weaponSlots) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(backpack);
        nbt.method_10566("weapon_slots", (class_2520)weaponSlots.toNbt());
        BackpackItem.setMetaComponent(backpack, new BackpackComponent(Instant.now().toEpochMilli()));
    }

    public static class_1799 getWeaponForArm(class_1799 backpack, BackpackArm arm) {
        return BackpackItem.getWeaponSlots(backpack).getWeaponForArm(arm);
    }

    public static void setWeaponForArm(class_1799 backpack, BackpackArm arm, class_1799 weapon) {
        BackpackItem.setWeaponSlots(backpack, BackpackItem.getWeaponSlots(backpack).setWeaponForArm(arm, weapon));
    }

    public static boolean hasAnyWeapons(class_1799 backpack) {
        return BackpackItem.getWeaponSlots(backpack).hasAnyWeapons();
    }

    public static boolean isAttackEnabled(class_1799 backpack) {
        class_2487 nbt = backpack.method_7969();
        if (nbt == null || !nbt.method_10545("attack_enabled")) {
            return true;
        }
        return nbt.method_10577("attack_enabled");
    }

    public static void setAttackEnabled(class_1799 backpack, boolean enabled) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(backpack);
        nbt.method_10556("attack_enabled", enabled);
    }

    public static boolean isItemPickupEnabled(class_1799 backpack) {
        class_2487 nbt = backpack.method_7969();
        if (nbt == null || !nbt.method_10545("item_pickup_enabled")) {
            return true;
        }
        return nbt.method_10577("item_pickup_enabled");
    }

    public static void setItemPickupEnabled(class_1799 backpack, boolean enabled) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(backpack);
        nbt.method_10556("item_pickup_enabled", enabled);
    }

    public static boolean isLocomotionEnabled(class_1799 backpack) {
        class_2487 nbt = backpack.method_7969();
        if (nbt == null || !nbt.method_10545("locomotion_enabled")) {
            return true;
        }
        return nbt.method_10577("locomotion_enabled");
    }

    public static void setLocomotionEnabled(class_1799 backpack, boolean enabled) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(backpack);
        nbt.method_10556("locomotion_enabled", enabled);
    }

    public static BackpackUpgradeSlotsComponent getUpgradeSlots(class_1799 backpack) {
        class_2487 nbt = backpack.method_7969();
        if (nbt == null || !nbt.method_10545("upgrade_slots")) {
            return BackpackUpgradeSlotsComponent.EMPTY;
        }
        return BackpackUpgradeSlotsComponent.fromNbt(nbt.method_10562("upgrade_slots"));
    }

    public static void setUpgradeSlots(class_1799 backpack, BackpackUpgradeSlotsComponent upgradeSlots) {
        class_2487 nbt = BackpackItem.getOrCreateBackpackNbt(backpack);
        nbt.method_10566("upgrade_slots", (class_2520)upgradeSlots.toNbt());
        BackpackItem.setMetaComponent(backpack, new BackpackComponent(Instant.now().toEpochMilli()));
    }

    public static class_1799 getUpgradeSlot(class_1799 backpack, int index) {
        return BackpackItem.getUpgradeSlots(backpack).getSlot(index);
    }

    public static void setUpgradeSlot(class_1799 backpack, int index, class_1799 upgrade) {
        BackpackItem.setUpgradeSlots(backpack, BackpackItem.getUpgradeSlots(backpack).setSlot(index, upgrade));
    }

    public static boolean hasUpgrade(class_1799 backpack, class_1792 upgradeItem) {
        BackpackUpgradeSlotsComponent slots = BackpackItem.getUpgradeSlots(backpack);
        for (int i = 0; i < 9; ++i) {
            if (!slots.getSlot(i).method_31574(upgradeItem)) continue;
            return true;
        }
        return false;
    }

    public static int countUpgrade(class_1799 backpack, class_1792 upgradeItem) {
        BackpackUpgradeSlotsComponent slots = BackpackItem.getUpgradeSlots(backpack);
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            if (!slots.getSlot(i).method_31574(upgradeItem)) continue;
            ++count;
        }
        return count;
    }

    public static int getMaxCapacity(class_1799 backpack) {
        int capacity = 1000;
        BackpackUpgradeSlotsComponent slots = BackpackItem.getUpgradeSlots(backpack);
        for (int i = 0; i < 9; ++i) {
            class_1799 upgrade = slots.getSlot(i);
            class_1792 class_17922 = upgrade.method_7909();
            if (!(class_17922 instanceof StorageUpgradeItem)) continue;
            StorageUpgradeItem storageUpgrade = (StorageUpgradeItem)class_17922;
            capacity += storageUpgrade.getCapacityBonus();
        }
        return capacity;
    }

    public static int getMaxRange(class_1799 backpack) {
        int maxRange = 1;
        BackpackUpgradeSlotsComponent slots = BackpackItem.getUpgradeSlots(backpack);
        for (int i = 0; i < 9; ++i) {
            class_1799 upgrade = slots.getSlot(i);
            class_1792 class_17922 = upgrade.method_7909();
            if (!(class_17922 instanceof RangeUpgradeItem)) continue;
            RangeUpgradeItem rangeUpgrade = (RangeUpgradeItem)class_17922;
            maxRange += rangeUpgrade.getRangeBonus();
        }
        return maxRange;
    }

    public static int getCurrentItemCount(class_1799 backpack) {
        List<BackpackItemComponent> inventory = BackpackItem.getReadonlyInventory(backpack, false);
        int total = 0;
        for (BackpackItemComponent item : inventory) {
            total += item.count();
        }
        return total;
    }

    public static boolean canRemoveStorageUpgrade(class_1799 backpack, StorageUpgradeItem upgradeToRemove) {
        int newMaxCapacity;
        int currentCount = BackpackItem.getCurrentItemCount(backpack);
        return currentCount <= (newMaxCapacity = BackpackItem.getMaxCapacity(backpack) - upgradeToRemove.getCapacityBonus());
    }

    public static int getItemsOverCapacity(class_1799 backpack, StorageUpgradeItem upgradeToRemove) {
        int currentCount = BackpackItem.getCurrentItemCount(backpack);
        int newMaxCapacity = BackpackItem.getMaxCapacity(backpack) - upgradeToRemove.getCapacityBonus();
        return Math.max(0, currentCount - newMaxCapacity);
    }

    public static int storeItemStack(class_1799 stackToStore, class_1799 backpack) {
        int currentCount;
        stackToStore = stackToStore.method_7972();
        int maxCapacity = BackpackItem.getMaxCapacity(backpack);
        int availableSpace = maxCapacity - (currentCount = BackpackItem.getCurrentItemCount(backpack));
        if (availableSpace <= 0) {
            return stackToStore.method_7947();
        }
        int toStore = Math.min(stackToStore.method_7947(), availableSpace);
        int remainder = stackToStore.method_7947() - toStore;
        if (toStore <= 0) {
            return stackToStore.method_7947();
        }
        stackToStore.method_7939(toStore);
        ArrayList<BackpackItemComponent> inventory = new ArrayList<BackpackItemComponent>(BackpackItem.getReadonlyInventory(backpack, false));
        for (BackpackItemComponent backpackItemComponent : inventory) {
            if (!BackpackItem.canStacksTogether(backpackItemComponent.item(), stackToStore)) continue;
            int newCount = backpackItemComponent.count() + stackToStore.method_7947();
            inventory.set(inventory.indexOf(backpackItemComponent), new BackpackItemComponent(backpackItemComponent.item(), newCount));
            BackpackItem.setInventory(backpack, inventory);
            BackpackItem.setMetaComponent(backpack, new BackpackComponent(Instant.now().toEpochMilli()));
            return remainder;
        }
        int count = stackToStore.method_7947();
        stackToStore.method_7939(1);
        inventory.add(new BackpackItemComponent(stackToStore, count));
        BackpackItem.setInventory(backpack, inventory);
        BackpackItem.setMetaComponent(backpack, new BackpackComponent(Instant.now().toEpochMilli()));
        return remainder;
    }

    public static class_1799 retrieveItemStack(class_1799 stackToRetrieve, class_1799 backpack) {
        stackToRetrieve = stackToRetrieve.method_7972();
        ArrayList<BackpackItemComponent> inventory = new ArrayList<BackpackItemComponent>(BackpackItem.getReadonlyInventory(backpack, false));
        for (BackpackItemComponent backpackItemComponent : inventory) {
            if (!BackpackItem.canStacksTogether(backpackItemComponent.item(), stackToRetrieve)) continue;
            if (stackToRetrieve.method_7947() > backpackItemComponent.count()) {
                stackToRetrieve.method_7939(backpackItemComponent.count());
            }
            int newCount = backpackItemComponent.count() - stackToRetrieve.method_7947();
            inventory.set(inventory.indexOf(backpackItemComponent), new BackpackItemComponent(backpackItemComponent.item(), newCount));
            BackpackItem.setInventory(backpack, inventory);
            BackpackItem.setMetaComponent(backpack, new BackpackComponent(Instant.now().toEpochMilli()));
            return stackToRetrieve;
        }
        return null;
    }

    public static boolean canStacksTogether(class_1799 a, class_1799 b) {
        if (a.method_7960() || b.method_7960()) {
            return false;
        }
        if (!a.method_31574(b.method_7909())) {
            return false;
        }
        if (a.method_7985() != b.method_7985()) {
            return false;
        }
        return !a.method_7985() || a.method_7969().equals((Object)b.method_7969());
    }

    public static void tick(class_1799 stack, class_1937 level, class_1297 entity) {
        if (level.field_9236) {
            return;
        }
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        ArrayList<BackpackBuildInstructionComponent> buildInstructions = new ArrayList<BackpackBuildInstructionComponent>(BackpackItem.getBuildInstructions(stack));
        int activeTasks = buildInstructions.size();
        if (BackpackItem.hasUpgrade(stack, (class_1792)FTechEquipment.ITEM_PICKUP_UPGRADE_ITEM.get())) {
            activeTasks += level.method_8390(class_1542.class, livingEntity.method_5829().method_1014(10.0), item -> true).size();
        }
        for (BackpackArm arm : BackpackArm.values()) {
            BackpackItem.updateArmPosition(arm, stack, level, livingEntity, activeTasks);
        }
        for (BackpackArm arm : BackpackArm.balancedOrder()) {
            BackpackItem.updateArmInstructions(stack, level, livingEntity, arm, buildInstructions);
        }
        BackpackItem.setBuildInstructions(stack, buildInstructions);
        if (BackpackItem.hasUpgrade(stack, (class_1792)FTechEquipment.LOCOMOTION_UPGRADE_ITEM.get())) {
            LocomotionController.tick(stack, level, livingEntity);
        }
    }

    private static void updateArmInstructions(class_1799 stack, class_1937 level, class_1309 livingEntity, BackpackArm backpackArm, List<BackpackBuildInstructionComponent> buildInstructions) {
        ArmAction action;
        BackpackArmComponent armData = BackpackItem.getArmData(backpackArm, stack);
        ArmActionContext ctx = new ArmActionContext(backpackArm, stack, level, livingEntity, armData, buildInstructions);
        if (armData.direction() == 0 && armData.progress() > 0.01f) {
            class_1799 holding = armData.holdingStack();
            boolean holdingDrill = holding.method_7909() instanceof RoboticDrillItem;
            boolean holdingWeapon = BackpackWeaponSlotsComponent.isValidWeapon(holding);
            if (holdingDrill || holdingWeapon) {
                for (ArmAction action2 : ArmActionRegistry.getByPriority()) {
                    ArmTask task;
                    boolean isMiningAction = action2.getId().method_12832().equals("mining");
                    boolean isAttackAction = action2.getId().method_12832().equals("attack");
                    if ((!holdingDrill || !isMiningAction) && (!holdingWeapon || !isAttackAction) || (task = action2.findTask(ctx)) == null) continue;
                    float redirectProgress = Math.min(armData.progress() * 0.3f, 0.4f);
                    BackpackArmComponent newData = new BackpackArmComponent(task.targetPos(), redirectProgress, 1, holding, action2.getId(), task.actionState());
                    BackpackItem.setArmData(backpackArm, stack, newData);
                    return;
                }
            }
        }
        if (armData.actionType() != null && (action = ArmActionRegistry.get(armData.actionType())) != null) {
            BackpackArmComponent newData = action.tick(ctx);
            if (newData != null) {
                BackpackItem.setArmData(backpackArm, stack, newData);
            }
            return;
        }
        if (armData.direction() == 0 && armData.progress() > 0.01f) {
            return;
        }
        if (armData.direction() == 0 && armData.progress() <= 0.01f) {
            int totalTasks = buildInstructions.size();
            if (BackpackItem.hasUpgrade(stack, (class_1792)FTechEquipment.ITEM_PICKUP_UPGRADE_ITEM.get())) {
                totalTasks += 10;
            }
            float stagnateAmount = totalTasks > 10 ? 0.05f : 0.3f;
            for (BackpackArm arm : BackpackArm.values()) {
                BackpackArmComponent otherArmData = BackpackItem.getArmData(arm, stack);
                if (!(otherArmData.progress() < stagnateAmount) || otherArmData.direction() != 1) continue;
                return;
            }
            for (ArmAction action3 : ArmActionRegistry.getByPriority()) {
                ArmTask task = action3.findTask(ctx);
                if (task == null) continue;
                BackpackArmComponent newData = new BackpackArmComponent(task.targetPos(), 0.01f, 1, task.holdingStack(), action3.getId(), task.actionState());
                BackpackItem.setArmData(backpackArm, stack, newData);
                return;
            }
        }
    }

    public static boolean lineOfSightToPos(class_243 pos, class_1309 player) {
        class_3965 hitRes = player.method_37908().method_17742(new class_3959(player.method_33571(), pos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        return hitRes.method_17783() == class_239.class_240.field_1333 || hitRes.method_17784().method_1022(pos) < 1.0;
    }

    private static void completeMining(class_1937 level, class_1799 stack, BackpackArm backpackArm, class_2338 blockPos, class_2680 minedBlock, class_1799 drill, RoboticDrillItem drillItem, class_2680 buildInstruction, List<BackpackBuildInstructionComponent> buildInstructions) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_8517(backpackArm.ordinal() + 1000, blockPos, -1);
        }
        List drops = class_2248.method_9609((class_2680)minedBlock, (class_3218)((class_3218)level), (class_2338)blockPos, (class_2586)level.method_8321(blockPos), null, (class_1799)drill);
        for (class_1799 drop : drops) {
            int remainder = BackpackItem.storeItemStack(drop, stack);
            if (remainder <= 0) continue;
            class_1799 toDrop = drop.method_7972();
            toDrop.method_7939(remainder);
            class_1542 itemEntity = new class_1542(level, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, toDrop);
            level.method_8649((class_1297)itemEntity);
        }
        level.method_20290(2001, blockPos, class_2248.method_9507((class_2680)minedBlock));
        if (!minedBlock.method_26227().method_15769()) {
            level.method_8652(blockPos, minedBlock.method_26227().method_15759(), 3);
        } else {
            level.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
        }
        boolean drillStillUsable = drillItem.damageAfterMining(drill);
        if (!drillStillUsable) {
            BackpackItem.setDrillForArm(stack, backpackArm, class_1799.field_8037);
        } else {
            BackpackItem.setDrillForArm(stack, backpackArm, drill);
        }
        BackpackArmComponent armData = BackpackItem.getArmData(backpackArm, stack);
        class_1799 retractingHoldingStack = drillStillUsable ? drill.method_7972() : class_1799.field_8037;
        BackpackItem.setArmData(backpackArm, stack, new BackpackArmComponent(armData.extendedPos(), armData.progress(), 0, retractingHoldingStack, 0, 0, -1));
        buildInstructions.removeIf(x -> FTechEquipment.blockPosesEqual(x.blockPos(), blockPos) && x.targetBlockState().equals(buildInstruction));
    }

    private static Optional<class_2680> getBuildTargetBlockState(class_1799 itemStack, class_1937 level, class_2338 pos, List<BackpackBuildInstructionComponent> buildInstructions) {
        class_2487 nbt = itemStack.method_7969();
        if (nbt == null || !nbt.method_10545("build_instructions")) {
            return Optional.empty();
        }
        class_2680 currentBlockState = level.method_8320(pos);
        for (BackpackBuildInstructionComponent buildInstruction : buildInstructions) {
            if (!FTechEquipment.blockPosesEqual(buildInstruction.blockPos(), pos)) continue;
            boolean breakInstruction = buildInstruction.targetBlockState().method_27852(class_2246.field_10369);
            if (breakInstruction) {
                if (currentBlockState.method_26215()) {
                    buildInstructions.removeIf(x -> FTechEquipment.blockPosesEqual(x.blockPos(), pos));
                    return Optional.empty();
                }
            } else if (!currentBlockState.method_26215() && !currentBlockState.method_45474()) {
                buildInstructions.removeIf(x -> FTechEquipment.blockPosesEqual(x.blockPos(), pos));
                return Optional.empty();
            }
            return Optional.of(buildInstruction.targetBlockState());
        }
        return Optional.empty();
    }

    private static void updateArmPosition(BackpackArm backpackArm, class_1799 stack, class_1937 level, class_1309 entity, int buildInstructionsCount) {
        float newProgress;
        BackpackArmComponent armData = BackpackItem.getArmData(backpackArm, stack);
        if (armData.progress() <= 0.01f && armData.direction() == 0) {
            return;
        }
        float speed = 0.1f + (float)buildInstructionsCount * 0.005f;
        speed = class_3532.method_15363((float)speed, (float)0.01f, (float)0.2f);
        if (armData.direction() == 2) {
            return;
        }
        if (armData.direction() == 1) {
            newProgress = class_3532.method_15363((float)(armData.progress() + speed), (float)0.001f, (float)1.0f);
        } else {
            newProgress = armData.progress() - speed;
            if (newProgress <= 0.01f) {
                int remainder;
                boolean shouldStore;
                boolean isPickupAction = armData.actionType() != null && armData.actionType().method_12832().equals("pickup");
                boolean isDrill = armData.holdingStack().method_7909() instanceof RoboticDrillItem;
                boolean isWeapon = BackpackWeaponSlotsComponent.isValidWeapon(armData.holdingStack());
                boolean bl = shouldStore = !armData.holdingStack().method_7960() && !armData.holdingStack().method_31574(class_1802.field_8615) && (isPickupAction || !isDrill && !isWeapon);
                if (shouldStore && (remainder = BackpackItem.storeItemStack(armData.holdingStack(), stack)) > 0) {
                    class_1799 toDrop = armData.holdingStack().method_7972();
                    toDrop.method_7939(remainder);
                    class_1542 itemEntity = new class_1542(level, entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), toDrop);
                    level.method_8649((class_1297)itemEntity);
                }
                class_1799 holdingAfterRetract = !isPickupAction && (isDrill || isWeapon) ? armData.holdingStack() : class_1799.field_8037;
                BackpackItem.setArmData(backpackArm, stack, armData.withProgress(0.0f).withDirection(0).withHolding(holdingAfterRetract).withActionType(null).withActionState(new class_2487()));
                return;
            }
        }
        BackpackItem.setArmData(backpackArm, stack, armData.withProgress(newProgress));
    }

    private static double getClosestBlockDistance(class_1309 player) {
        String key = player.method_5667().toString();
        double targetDistance = BackpackItem.getRawClosestBlockDistance(player);
        Double currentSmoothed = smoothedClosestBlockDistance.get(key);
        if (currentSmoothed == null) {
            smoothedClosestBlockDistance.put(key, targetDistance);
            return targetDistance;
        }
        double newSmoothed = currentSmoothed + (targetDistance - currentSmoothed) * 0.15;
        smoothedClosestBlockDistance.put(key, newSmoothed);
        return newSmoothed;
    }

    private static double getRawClosestBlockDistance(class_1309 player) {
        String key = player.method_5667().toString();
        long currentTime = player.method_37908().method_8510();
        double[] cached = closestBlockDistanceCache.get(key);
        if (cached != null && cached[1] == (double)currentTime) {
            return cached[0];
        }
        class_1937 level = player.method_37908();
        class_243 waistPos = player.method_19538().method_1031(0.0, (double)player.method_17682() * 0.5, 0.0);
        double closestDistance = Double.MAX_VALUE;
        int radius = 4;
        class_2338 waistBlockPos = class_2338.method_49638((class_2374)waistPos);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y <= radius; ++y) {
                    double dist;
                    class_2338 checkPos = waistBlockPos.method_10069(x, y, z);
                    class_2680 state = level.method_8320(checkPos);
                    if (state.method_26215() || state.method_26220((class_1922)level, checkPos).method_1110() || !((dist = waistPos.method_1022(class_243.method_24953((class_2382)checkPos))) < closestDistance)) continue;
                    closestDistance = dist;
                }
            }
        }
        if (closestDistance == Double.MAX_VALUE) {
            closestDistance = (double)radius + 1.0;
        }
        closestBlockDistanceCache.put(key, new double[]{closestDistance, currentTime});
        return closestDistance;
    }

    public static List<BackpackArmPath> getPartialArmPath(class_1309 player, BackpackArm arm, class_243 extendedPos, float tickDelta, float progress) {
        if (progress <= 0.01f) {
            return new ArrayList<BackpackArmPath>();
        }
        List<BackpackArmPath> fullArmPath = BackpackItem.getArmPath(player, arm, extendedPos, tickDelta);
        if (progress >= 0.99f) {
            return fullArmPath;
        }
        int index = Math.min(Math.round(progress * (float)fullArmPath.size()), fullArmPath.size() - 1);
        class_243 targetPos = fullArmPath.get(index).pos();
        return BackpackItem.getArmPath(player, arm, targetPos, tickDelta);
    }

    public static List<BackpackArmPath> getArmPath(class_1309 player, BackpackArm arm, class_243 extendedPos, float tickDelta) {
        ArrayList<BackpackArmPath> backpackArmPath = new ArrayList<BackpackArmPath>();
        class_243 startPos = BackpackItem.getBackpackArmStartPos(player, tickDelta, arm);
        float bodyYaw = BackpackItem.getBodyYawForPlayer(player, tickDelta);
        double closestBlockDist = BackpackItem.getClosestBlockDistance(player);
        double armReachDist = startPos.method_1022(extendedPos);
        class_243 currentPos = startPos;
        class_243 previousDelta = new class_243(0.0, (double)0.06f, 0.0);
        if (arm == BackpackArm.TOP_LEFT) {
            previousDelta = previousDelta.method_31033((float)Math.toRadians(40.0));
        } else if (arm == BackpackArm.TOP_LEFT_UPPER) {
            previousDelta = previousDelta.method_31033((float)Math.toRadians(20.0));
        } else if (arm == BackpackArm.TOP_LEFT_LOWER) {
            previousDelta = previousDelta.method_31033((float)Math.toRadians(60.0));
        } else if (arm == BackpackArm.LEFT) {
            previousDelta = previousDelta.method_31033((float)Math.toRadians(80.0));
        } else if (arm == BackpackArm.TOP_RIGHT) {
            previousDelta = previousDelta.method_31033((float)Math.toRadians(-40.0));
        } else if (arm == BackpackArm.TOP_RIGHT_UPPER) {
            previousDelta = previousDelta.method_31033((float)Math.toRadians(-20.0));
        } else if (arm == BackpackArm.TOP_RIGHT_LOWER) {
            previousDelta = previousDelta.method_31033((float)Math.toRadians(-60.0));
        } else if (arm == BackpackArm.RIGHT) {
            previousDelta = previousDelta.method_31033((float)Math.toRadians(-80.0));
        }
        previousDelta = previousDelta.method_1024((float)Math.toRadians(-bodyYaw));
        for (int i = 0; i < 1000; ++i) {
            class_243 delta = new class_243(0.0, (double)0.06f, 0.0);
            if (i > 10) {
                delta = extendedPos.method_1020(currentPos).method_1029().method_1021((double)0.06f);
            }
            delta = BackpackItem.getDeltaTowardsDirection(previousDelta, delta, closestBlockDist, armReachDist);
            currentPos = currentPos.method_1019(delta);
            previousDelta = delta;
            backpackArmPath.add(new BackpackArmPath(currentPos, delta));
            if (currentPos.method_1022(extendedPos) <= (double)0.2f) break;
        }
        return backpackArmPath;
    }

    private static class_243 getDeltaTowardsDirection(class_243 previousDelta, class_243 targetDelta, double closestBlockDistance, double armReachDistance) {
        double t = (closestBlockDistance - 2.0) / 3.0;
        t = Math.max(0.0, Math.min(1.0, t));
        double balance = (double)0.93f + t * 0.029999971389770508;
        if (armReachDistance < 3.0) {
            double reachFactor = armReachDistance / 3.0;
            balance = (double)0.93f + reachFactor * (balance - (double)0.93f);
        }
        return new class_243(previousDelta.field_1352 * balance + targetDelta.field_1352 * (1.0 - balance), previousDelta.field_1351 * balance + targetDelta.field_1351 * (1.0 - balance), previousDelta.field_1350 * balance + targetDelta.field_1350 * (1.0 - balance));
    }

    private static class_243 getBackpackArmStartPos(class_1309 player, float tickDelta, BackpackArm arm) {
        Quaternionf bodyRot = new Quaternionf();
        bodyRot = bodyRot.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(-BackpackItem.getBodyYawForPlayer(player, tickDelta)));
        float sidewaysAmt = 0.0f;
        sidewaysAmt = arm == BackpackArm.TOP_LEFT || arm == BackpackArm.TOP_LEFT_UPPER || arm == BackpackArm.TOP_LEFT_LOWER || arm == BackpackArm.LEFT ? 0.25f : -0.25f;
        float isSelfMoveBackAmt = Services.PLATFORM.getFirstPersonBackOffset(player);
        if (player.method_5681() || player.method_6128() || player.method_20448()) {
            float pitch = class_3532.method_16439((float)tickDelta, (float)player.field_6004, (float)player.method_36455());
            float bodyTilt = 90.0f + pitch;
            bodyRot = bodyRot.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(bodyTilt));
            return BackpackItem.getInDirection(BackpackItem.getPosForPlayer(player, tickDelta).method_1031(0.0, (double)0.3f, 0.0), bodyRot, new Vector3f(sidewaysAmt, 0.0f, -0.25f + isSelfMoveBackAmt));
        }
        if (player.method_18276()) {
            bodyRot = bodyRot.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(25.0f));
            return BackpackItem.getInDirection(BackpackItem.getPosForPlayer(player, tickDelta).method_1031(0.0, (double)0.8f, 0.0), bodyRot, new Vector3f(sidewaysAmt, 0.0f, -0.35f + isSelfMoveBackAmt));
        }
        return BackpackItem.getInDirection(BackpackItem.getPosForPlayer(player, tickDelta).method_1031(0.0, (double)1.2f, 0.0), bodyRot, new Vector3f(sidewaysAmt, 0.0f, -0.25f + isSelfMoveBackAmt));
    }

    private static class_243 getInDirection(class_243 currentPosition, Quaternionf currentRotation, Vector3f currentDirection) {
        currentDirection = currentDirection.rotate((Quaternionfc)currentRotation);
        class_243 currentDirection2 = new class_243((double)currentDirection.x, (double)currentDirection.y, (double)currentDirection.z);
        return currentPosition.method_1019(currentDirection2);
    }

    private static float getBodyYawForPlayer(class_1309 player, float tickDelta) {
        if (tickDelta == 1.0f) {
            return player.field_6283;
        }
        return class_3532.method_16439((float)tickDelta, (float)player.field_6220, (float)player.field_6283);
    }

    private static class_243 getPosForPlayer(class_1309 player, float tickDelta) {
        if (tickDelta == 1.0f) {
            return player.method_19538();
        }
        return new class_243((double)class_3532.method_16439((float)tickDelta, (float)((float)player.field_6014), (float)((float)player.method_23317())), (double)class_3532.method_16439((float)tickDelta, (float)((float)player.field_6036), (float)((float)player.method_23318())), (double)class_3532.method_16439((float)tickDelta, (float)((float)player.field_5969), (float)((float)player.method_23321())));
    }

    private static BackpackArmPath getClosestPointOnArmPath(List<BackpackArmPath> armPath, class_243 point) {
        BackpackArmPath closestPoint = null;
        double closestDistance = Double.MAX_VALUE;
        for (BackpackArmPath path : armPath) {
            double distance = path.pos().method_1022(point);
            if (!(distance < closestDistance)) continue;
            closestPoint = path;
            closestDistance = distance;
        }
        return closestPoint;
    }

    public static boolean lineOfSightToBlock(class_2338 pos, class_1309 player) {
        class_3965 hitRes = player.method_37908().method_17742(new class_3959(player.method_33571(), pos.method_46558(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        return FTechEquipment.blockPosesEqual(hitRes.method_17777(), pos);
    }

    private static class_2350 getVerticalFacing(class_1309 player) {
        float pitch = player.method_36455();
        if (pitch < -45.0f) {
            return class_2350.field_11036;
        }
        if (pitch > 45.0f) {
            return class_2350.field_11033;
        }
        return player.method_5735();
    }

    public static List<class_2338> getReplicateBlocks(class_2338 startingPos, class_1309 player) {
        class_1799 backpack = FTechEquipment.getBackpackOnPlayer(player);
        if (backpack == null || !BackpackItem.hasUpgrade(backpack, (class_1792)FTechEquipment.BLOCK_OPERATIONS_UPGRADE_ITEM.get())) {
            return new ArrayList<class_2338>();
        }
        BackpackBuildInstructionsReplicateParamsComponent replicateParams = BackpackItem.getReplicateParams(player);
        if (!replicateParams.enabled()) {
            return new ArrayList<class_2338>();
        }
        class_2350 verticalFacing = BackpackItem.getVerticalFacing(player);
        class_2350 upDirection = verticalFacing == class_2350.field_11036 ? (player.method_5735() == class_2350.field_11043 ? class_2350.field_11035 : (player.method_5735() == class_2350.field_11035 ? class_2350.field_11043 : (player.method_5735() == class_2350.field_11034 ? class_2350.field_11039 : class_2350.field_11034))) : (verticalFacing == class_2350.field_11033 ? (player.method_5735() == class_2350.field_11043 ? class_2350.field_11043 : (player.method_5735() == class_2350.field_11035 ? class_2350.field_11035 : (player.method_5735() == class_2350.field_11034 ? class_2350.field_11034 : class_2350.field_11039))) : class_2350.field_11036);
        class_2350 rightDirection = player.method_5735() == class_2350.field_11043 ? class_2350.field_11034 : (player.method_5735() == class_2350.field_11035 ? class_2350.field_11039 : (player.method_5735() == class_2350.field_11034 ? class_2350.field_11035 : class_2350.field_11043));
        ArrayList<class_2338> replicateBlocks = new ArrayList<class_2338>();
        for (int leftRightAmt = -replicateParams.extendLeft(); leftRightAmt <= replicateParams.extendRight(); ++leftRightAmt) {
            for (int upDownAmt = -replicateParams.extendDown(); upDownAmt <= replicateParams.extendUp(); ++upDownAmt) {
                replicateBlocks.add(startingPos.method_10079(rightDirection, leftRightAmt).method_10079(upDirection, upDownAmt));
            }
        }
        return replicateBlocks;
    }
}

