/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment.backpack;

import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.backpack.RoboticDrillItem;

public record BackpackArmComponent(class_243 extendedPos, float progress, int direction, class_1799 holdingStack, @Nullable class_2960 actionType, class_2487 actionState) {
    public static final String ACTION_MINING = "mining";
    public static final String ACTION_PLACING = "placing";
    public static final String ACTION_PICKUP = "pickup";
    private static final String KEY_MINING_PROGRESS = "miningProgress";
    private static final String KEY_MINING_TOTAL_TICKS = "miningTotalTicks";
    private static final String KEY_PICKUP_TARGET_ENTITY_ID = "pickupTargetEntityId";

    public BackpackArmComponent(class_243 extendedPos, float progress, int direction, class_1799 holdingStack) {
        this(extendedPos, progress, direction, holdingStack, null, new class_2487());
    }

    public BackpackArmComponent(class_243 extendedPos, float progress, int direction, class_1799 holdingStack, int miningProgress, int miningTotalTicks) {
        this(extendedPos, progress, direction, holdingStack, miningProgress, miningTotalTicks, -1);
    }

    public BackpackArmComponent(class_243 extendedPos, float progress, int direction, class_1799 holdingStack, int miningProgress, int miningTotalTicks, int pickupTargetEntityId) {
        this(extendedPos, progress, direction, holdingStack, BackpackArmComponent.determineActionType(miningTotalTicks, pickupTargetEntityId, holdingStack, direction), BackpackArmComponent.createActionState(miningProgress, miningTotalTicks, pickupTargetEntityId));
    }

    public BackpackArmComponent withExtendedPos(class_243 pos) {
        return new BackpackArmComponent(pos, this.progress, this.direction, this.holdingStack, this.actionType, this.actionState);
    }

    public BackpackArmComponent withProgress(float p) {
        return new BackpackArmComponent(this.extendedPos, p, this.direction, this.holdingStack, this.actionType, this.actionState);
    }

    public BackpackArmComponent withDirection(int d) {
        return new BackpackArmComponent(this.extendedPos, this.progress, d, this.holdingStack, this.actionType, this.actionState);
    }

    public BackpackArmComponent withHolding(class_1799 stack) {
        return new BackpackArmComponent(this.extendedPos, this.progress, this.direction, stack, this.actionType, this.actionState);
    }

    public BackpackArmComponent withActionType(@Nullable class_2960 type) {
        return new BackpackArmComponent(this.extendedPos, this.progress, this.direction, this.holdingStack, type, this.actionState);
    }

    public BackpackArmComponent withActionState(class_2487 state) {
        return new BackpackArmComponent(this.extendedPos, this.progress, this.direction, this.holdingStack, this.actionType, state);
    }

    public BackpackArmComponent startRetracting() {
        return new BackpackArmComponent(this.extendedPos, this.progress, 0, this.holdingStack, this.actionType, this.actionState);
    }

    public BackpackArmComponent idle() {
        return new BackpackArmComponent(class_243.field_1353, 0.0f, 0, class_1799.field_8037, null, new class_2487());
    }

    public boolean isIdle() {
        return this.actionType == null && this.progress <= 0.01f;
    }

    public boolean isActionType(String actionName) {
        return this.actionType != null && this.actionType.method_12832().equals(actionName);
    }

    @Deprecated
    public boolean isPickupTask() {
        return this.isActionType(ACTION_PICKUP) || this.pickupTargetEntityId() >= 0;
    }

    @Deprecated
    public int miningProgress() {
        return this.actionState.method_10545(KEY_MINING_PROGRESS) ? this.actionState.method_10550(KEY_MINING_PROGRESS) : 0;
    }

    @Deprecated
    public int miningTotalTicks() {
        return this.actionState.method_10545(KEY_MINING_TOTAL_TICKS) ? this.actionState.method_10550(KEY_MINING_TOTAL_TICKS) : 0;
    }

    @Deprecated
    public int pickupTargetEntityId() {
        return this.actionState.method_10545(KEY_PICKUP_TARGET_ENTITY_ID) ? this.actionState.method_10550(KEY_PICKUP_TARGET_ENTITY_ID) : -1;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10549("extendedPosX", this.extendedPos.field_1352);
        nbt.method_10549("extendedPosY", this.extendedPos.field_1351);
        nbt.method_10549("extendedPosZ", this.extendedPos.field_1350);
        nbt.method_10548("progress", this.progress);
        nbt.method_10569("direction", this.direction);
        nbt.method_10566("holdingStack", (class_2520)this.holdingStack.method_7953(new class_2487()));
        if (this.actionType != null) {
            nbt.method_10582("actionType", this.actionType.toString());
        }
        if (!this.actionState.method_33133()) {
            nbt.method_10566("actionState", (class_2520)this.actionState.method_10553());
        }
        nbt.method_10569(KEY_MINING_PROGRESS, this.miningProgress());
        nbt.method_10569(KEY_MINING_TOTAL_TICKS, this.miningTotalTicks());
        nbt.method_10569(KEY_PICKUP_TARGET_ENTITY_ID, this.pickupTargetEntityId());
        return nbt;
    }

    public static BackpackArmComponent fromNbt(class_2487 nbt) {
        class_243 extendedPos = new class_243(nbt.method_10574("extendedPosX"), nbt.method_10574("extendedPosY"), nbt.method_10574("extendedPosZ"));
        float progress = nbt.method_10583("progress");
        int direction = nbt.method_10550("direction");
        class_1799 holdingStack = class_1799.method_7915((class_2487)nbt.method_10562("holdingStack"));
        if (nbt.method_10545("actionType")) {
            class_2960 actionType = class_2960.method_12829((String)nbt.method_10558("actionType"));
            class_2487 actionState = nbt.method_10545("actionState") ? nbt.method_10562("actionState").method_10553() : new class_2487();
            return new BackpackArmComponent(extendedPos, progress, direction, holdingStack, actionType, actionState);
        }
        int miningProgress = nbt.method_10550(KEY_MINING_PROGRESS);
        int miningTotalTicks = nbt.method_10550(KEY_MINING_TOTAL_TICKS);
        int pickupTargetEntityId = nbt.method_10545(KEY_PICKUP_TARGET_ENTITY_ID) ? nbt.method_10550(KEY_PICKUP_TARGET_ENTITY_ID) : -1;
        class_2960 actionType = BackpackArmComponent.determineActionType(miningTotalTicks, pickupTargetEntityId, holdingStack, direction);
        class_2487 actionState = BackpackArmComponent.createActionState(miningProgress, miningTotalTicks, pickupTargetEntityId);
        return new BackpackArmComponent(extendedPos, progress, direction, holdingStack, actionType, actionState);
    }

    public static BackpackArmComponent getDefault() {
        return new BackpackArmComponent(class_243.field_1353, 0.0f, 0, class_1799.field_8037, null, new class_2487());
    }

    @Nullable
    private static class_2960 determineActionType(int miningTotalTicks, int pickupTargetEntityId, class_1799 holdingStack, int direction) {
        if (direction == 0 && miningTotalTicks == 0 && pickupTargetEntityId < 0) {
            return null;
        }
        if (pickupTargetEntityId >= 0) {
            return new class_2960("f_tech_equipment", ACTION_PICKUP);
        }
        if (miningTotalTicks > 0 || holdingStack.method_7909() instanceof RoboticDrillItem) {
            return new class_2960("f_tech_equipment", ACTION_MINING);
        }
        if (!holdingStack.method_7960() && direction == 1) {
            return new class_2960("f_tech_equipment", ACTION_PLACING);
        }
        return null;
    }

    private static class_2487 createActionState(int miningProgress, int miningTotalTicks, int pickupTargetEntityId) {
        class_2487 state = new class_2487();
        if (miningProgress > 0) {
            state.method_10569(KEY_MINING_PROGRESS, miningProgress);
        }
        if (miningTotalTicks > 0) {
            state.method_10569(KEY_MINING_TOTAL_TICKS, miningTotalTicks);
        }
        if (pickupTargetEntityId >= 0) {
            state.method_10569(KEY_PICKUP_TARGET_ENTITY_ID, pickupTargetEntityId);
        }
        return state;
    }
}

