/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.ftech_equipment;

import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7701;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.ftech_equipment.FTechEquipmentKeybindings;
import uk.co.cablepost.ftech_equipment.FoliageClearerItem;
import uk.co.cablepost.ftech_equipment.backpack.BackpackBuildInstructionComponent;
import uk.co.cablepost.ftech_equipment.backpack.BackpackItem;
import uk.co.cablepost.ftech_equipment.backpack.RoboticDrillItem;
import uk.co.cablepost.ftech_equipment.backpack.build_instructions_client.BackpackBuildInstructionsReplicateParamsComponent;
import uk.co.cablepost.ftech_equipment.backpack.inventory.BackpackInventoryMenu;
import uk.co.cablepost.ftech_equipment.backpack.upgrade.BlockOperationsUpgradeItem;
import uk.co.cablepost.ftech_equipment.backpack.upgrade.CombatUpgradeItem;
import uk.co.cablepost.ftech_equipment.backpack.upgrade.ItemPickupUpgradeItem;
import uk.co.cablepost.ftech_equipment.backpack.upgrade.LocomotionUpgradeItem;
import uk.co.cablepost.ftech_equipment.backpack.upgrade.QueueUpgradeItem;
import uk.co.cablepost.ftech_equipment.backpack.upgrade.RangeUpgradeItem;
import uk.co.cablepost.ftech_equipment.backpack.upgrade.StorageUpgradeItem;
import uk.co.cablepost.ftech_equipment.networking.FTechEquipmentNetworking;
import uk.co.cablepost.ftech_equipment.platform.EquipmentSlotHelper;

public class FTechEquipment {
    public static final String MOD_ID = "f_tech_equipment";
    public static final String NBT_KEY_ARM_TOP_LEFT = "arm_top_left";
    public static final String NBT_KEY_ARM_TOP_LEFT_UPPER = "arm_top_left_upper";
    public static final String NBT_KEY_ARM_TOP_LEFT_LOWER = "arm_top_left_lower";
    public static final String NBT_KEY_ARM_LEFT = "arm_left";
    public static final String NBT_KEY_ARM_TOP_RIGHT = "arm_top_right";
    public static final String NBT_KEY_ARM_TOP_RIGHT_UPPER = "arm_top_right_upper";
    public static final String NBT_KEY_ARM_TOP_RIGHT_LOWER = "arm_top_right_lower";
    public static final String NBT_KEY_ARM_RIGHT = "arm_right";
    public static final String NBT_KEY_BUILD_INSTRUCTIONS = "build_instructions";
    public static final String NBT_KEY_BUILD_INSTRUCTIONS_REPLICATE = "build_instructions_replicate";
    public static final String NBT_KEY_ITEMS = "items";
    public static final String NBT_KEY_BACKPACK = "backpack";
    public static final String NBT_KEY_DRILL_SLOTS = "drill_slots";
    public static final String NBT_KEY_UPGRADE_SLOTS = "upgrade_slots";
    public static final String NBT_KEY_PICKUP_INSTRUCTIONS = "pickup_instructions";
    public static final String NBT_KEY_ITEM_PICKUP_ENABLED = "item_pickup_enabled";
    public static final String NBT_KEY_WEAPON_SLOTS = "weapon_slots";
    public static final String NBT_KEY_ATTACK_ENABLED = "attack_enabled";
    public static final String NBT_KEY_LOCOMOTION_ENABLED = "locomotion_enabled";
    public static final class_2960 BACKPACK_BUILD_INSTRUCTIONS_REPLICATE_PACKET_ID = new class_2960("f_tech_equipment", "backpack_build_instructions_replicate_packet");
    public static final class_2960 BACKPACK_ITEM_PICKUP_TOGGLE_PACKET_ID = new class_2960("f_tech_equipment", "backpack_item_pickup_toggle_packet");
    public static final class_2960 BACKPACK_INVENTORY_ACTION_PACKET_ID = new class_2960("f_tech_equipment", "backpack_inventory_action_packet");
    public static final class_2960 BACKPACK_OPEN_INVENTORY_PACKET_ID = new class_2960("f_tech_equipment", "backpack_open_inventory_packet");
    public static final class_2960 BACKPACK_DRILL_SLOT_ACTION_PACKET_ID = new class_2960("f_tech_equipment", "backpack_drill_slot_action_packet");
    public static final class_2960 BACKPACK_UPGRADE_SLOT_ACTION_PACKET_ID = new class_2960("f_tech_equipment", "backpack_upgrade_slot_action_packet");
    public static final class_2960 BACKPACK_WEAPON_SLOT_ACTION_PACKET_ID = new class_2960("f_tech_equipment", "backpack_weapon_slot_action_packet");
    public static final class_2960 BACKPACK_ATTACK_TOGGLE_PACKET_ID = new class_2960("f_tech_equipment", "backpack_attack_toggle_packet");
    public static final class_2960 BACKPACK_LOCOMOTION_TOGGLE_PACKET_ID = new class_2960("f_tech_equipment", "backpack_locomotion_toggle_packet");
    public static final class_2960 BACKPACK_LOCOMOTION_VELOCITY_SYNC_PACKET_ID = new class_2960("f_tech_equipment", "backpack_locomotion_velocity_sync_packet");
    public static final class_2960 BACKPACK_UPDATE_MENU_CONTAINER_DATA = new class_2960("f_tech_equipment", "backpack_update_menu_container_data");
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"f_tech_equipment", (class_5321)class_7924.field_41197);
    public static final DeferredRegister<class_3414> SOUND_EVENTS = DeferredRegister.create((String)"f_tech_equipment", (class_5321)class_7924.field_41225);
    public static final DeferredRegister<class_1761> CREATIVE_TABS = DeferredRegister.create((String)"f_tech_equipment", (class_5321)class_7924.field_44688);
    public static final DeferredRegister<class_3917<?>> MENUS = DeferredRegister.create((String)"f_tech_equipment", (class_5321)class_7924.field_41207);
    public static final class_2960 ROBOT_ARM_SOUND_ID = new class_2960("f_tech_equipment", "robot_arm");
    public static final RegistrySupplier<class_3414> ROBOT_ARM_SOUND = SOUND_EVENTS.register("robot_arm", () -> class_3414.method_47908((class_2960)ROBOT_ARM_SOUND_ID));
    public static final RegistrySupplier<class_3917<BackpackInventoryMenu>> BACKPACK_INVENTORY_MENU = MENUS.register("backpack_inventory", () -> new class_3917(BackpackInventoryMenu::new, class_7701.field_40182));
    public static final RegistrySupplier<BackpackItem> BACKPACK_ITEM = ITEMS.register("backpack", () -> new BackpackItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8904)));
    public static final RegistrySupplier<RoboticDrillItem> ROBOTIC_DRILL_ITEM = ITEMS.register("robotic_drill", () -> new RoboticDrillItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8903)));
    public static final RegistrySupplier<FoliageClearerItem> FOLIAGE_CLEARER_ITEM = ITEMS.register("foliage_clearer", () -> new FoliageClearerItem(new class_1792.class_1793().method_7889(1).method_7895(256).method_7894(class_1814.field_8907)));
    public static final RegistrySupplier<class_1792> BLANK_UPGRADE = ITEMS.register("blank_upgrade", () -> new class_1792(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8906)));
    public static final RegistrySupplier<BlockOperationsUpgradeItem> BLOCK_OPERATIONS_UPGRADE_ITEM = ITEMS.register("block_operations_upgrade", () -> new BlockOperationsUpgradeItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8903)));
    public static final RegistrySupplier<QueueUpgradeItem> QUEUE_UPGRADE_ITEM = ITEMS.register("queue_upgrade", () -> new QueueUpgradeItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8903)));
    public static final RegistrySupplier<StorageUpgradeItem> STORAGE_UPGRADE_1_ITEM = ITEMS.register("storage_upgrade_1", () -> new StorageUpgradeItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8907), 1, 500));
    public static final RegistrySupplier<StorageUpgradeItem> STORAGE_UPGRADE_2_ITEM = ITEMS.register("storage_upgrade_2", () -> new StorageUpgradeItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8903), 2, 1000));
    public static final RegistrySupplier<StorageUpgradeItem> STORAGE_UPGRADE_3_ITEM = ITEMS.register("storage_upgrade_3", () -> new StorageUpgradeItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8904), 3, 2000));
    public static final RegistrySupplier<ItemPickupUpgradeItem> ITEM_PICKUP_UPGRADE_ITEM = ITEMS.register("item_pickup_upgrade", () -> new ItemPickupUpgradeItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8903)));
    public static final RegistrySupplier<RangeUpgradeItem> RANGE_UPGRADE_ITEM = ITEMS.register("range_upgrade", () -> new RangeUpgradeItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8907), 1));
    public static final RegistrySupplier<CombatUpgradeItem> COMBAT_UPGRADE_ITEM = ITEMS.register("combat_upgrade", () -> new CombatUpgradeItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8903)));
    public static final RegistrySupplier<LocomotionUpgradeItem> LOCOMOTION_UPGRADE_ITEM = ITEMS.register("locomotion_upgrade", () -> new LocomotionUpgradeItem(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8904)));
    public static final RegistrySupplier<class_1761> ITEM_GROUP = CREATIVE_TABS.register("main_creative_inventory_tab", () -> CreativeTabRegistry.create(builder -> builder.method_47321((class_2561)class_2561.method_43471((String)"itemGroup.f_tech_equipment.items")).method_47320(() -> new class_1799((class_1935)BACKPACK_ITEM.get())).method_47317((parameters, output) -> {
        output.method_45421((class_1935)BACKPACK_ITEM.get());
        output.method_45421((class_1935)ROBOTIC_DRILL_ITEM.get());
        output.method_45421((class_1935)FOLIAGE_CLEARER_ITEM.get());
        output.method_45421((class_1935)BLANK_UPGRADE.get());
        output.method_45421((class_1935)BLOCK_OPERATIONS_UPGRADE_ITEM.get());
        output.method_45421((class_1935)QUEUE_UPGRADE_ITEM.get());
        output.method_45421((class_1935)STORAGE_UPGRADE_1_ITEM.get());
        output.method_45421((class_1935)STORAGE_UPGRADE_2_ITEM.get());
        output.method_45421((class_1935)STORAGE_UPGRADE_3_ITEM.get());
        output.method_45421((class_1935)ITEM_PICKUP_UPGRADE_ITEM.get());
        output.method_45421((class_1935)RANGE_UPGRADE_ITEM.get());
        output.method_45421((class_1935)COMBAT_UPGRADE_ITEM.get());
        output.method_45421((class_1935)LOCOMOTION_UPGRADE_ITEM.get());
    })));

    public static void init() {
        ITEMS.register();
        SOUND_EVENTS.register();
        CREATIVE_TABS.register();
        MENUS.register();
        FTechEquipmentNetworking.registerServerReceivers();
    }

    public static void initClient() {
        FTechEquipmentKeybindings.registerKeybindings();
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    @Nullable
    public static class_1799 getBackpackOnPlayer(class_1309 player) {
        return EquipmentSlotHelper.getEquippedBackpack(player, (class_1792)BACKPACK_ITEM.get());
    }

    public static boolean blockPosesEqual(class_2338 a, class_2338 b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.method_10263() == b.method_10263() && a.method_10264() == b.method_10264() && a.method_10260() == b.method_10260();
    }

    public static void addBuildInstructions(class_3222 player, class_2338 blockPos, class_2680 blockState) {
        class_1799 backpackItem = FTechEquipment.getBackpackOnPlayer((class_1309)player);
        if (backpackItem == null) {
            return;
        }
        if (!BackpackItem.hasUpgrade(backpackItem, (class_1792)BLOCK_OPERATIONS_UPGRADE_ITEM.get())) {
            return;
        }
        BackpackBuildInstructionsReplicateParamsComponent params = BackpackItem.getReplicateParams((class_1309)player);
        if (!params.enabled()) {
            return;
        }
        if (!BackpackItem.hasUpgrade(backpackItem, (class_1792)QUEUE_UPGRADE_ITEM.get()) && !BackpackItem.getBuildInstructions(backpackItem).isEmpty()) {
            return;
        }
        List<class_2338> posList = BackpackItem.getReplicateBlocks(blockPos, (class_1309)player);
        ArrayList<BackpackBuildInstructionComponent> instructions = new ArrayList<BackpackBuildInstructionComponent>();
        boolean hasDrills = BackpackItem.hasAnyDrills(backpackItem);
        for (class_2338 pos : posList) {
            class_2680 currentState;
            if (FTechEquipment.blockPosesEqual(pos, blockPos) || (blockState.method_27852(class_2246.field_10369) ? (currentState = player.method_37908().method_8320(pos)).method_26215() || !hasDrills : !(currentState = player.method_37908().method_8320(pos)).method_26215() && !currentState.method_45474())) continue;
            instructions.add(new BackpackBuildInstructionComponent(blockState, pos));
        }
        BackpackItem.addBuildInstructions(backpackItem, instructions);
    }
}

